/*
 * Decompiled with CFR 0.152.
 */
package com.acucorp.acucobolgt;

import com.acucorp.acucobolgt.CVM;
import com.acucorp.acucobolgt.DefaultRemoteServer;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Logger;

public class RemoteConnect {
    private static Logger _log = Logger.getLogger("com.acucorp.acucobolgt.CVM");

    private RemoteConnect() {
    }

    public static int RegisterServer(Remote remote, int n, String string) {
        try {
            Remote remote2 = UnicastRemoteObject.exportObject(remote, n);
            Registry registry = LocateRegistry.getRegistry();
            registry.bind(string, remote2);
            _log.info("Remote Server ready");
        }
        catch (Exception exception) {
            _log.info(exception.getMessage());
            CVM.WriteExceptiontoLog(_log, exception);
        }
        return 0;
    }

    public static int RegisterDefaultServer(int n) {
        try {
            DefaultRemoteServer defaultRemoteServer = new DefaultRemoteServer();
            Remote remote = UnicastRemoteObject.exportObject((Remote)defaultRemoteServer, n);
            Registry registry = LocateRegistry.getRegistry();
            registry.bind("DefaultRemoteServer", remote);
            _log.info("Remote Server ready");
        }
        catch (Exception exception) {
            _log.info(exception.getMessage());
            CVM.WriteExceptiontoLog(_log, exception);
        }
        return 0;
    }

    public static Remote CreateRemoteObject(String string, String string2, int n) {
        Remote remote = null;
        try {
            _log.info("CreateRemoteObject called with Host: " + string + " Server: " + string2 + " Port: " + n);
            Registry registry = n == 0 ? LocateRegistry.getRegistry(string) : LocateRegistry.getRegistry(string, n);
            remote = registry.lookup(string2);
            _log.info("Remote object created");
        }
        catch (Exception exception) {
            _log.info(exception.getMessage());
            CVM.WriteExceptiontoLog(_log, exception);
        }
        return remote;
    }
}

