/*
 * Decompiled with CFR 0.152.
 */
package com.acucorp.acucobolgt;

import com.acucorp.acucobolgt.CVM;
import com.acucorp.acucobolgt.StatusInfo;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class runcbl {
    private static int _retint = -1;
    private static boolean _retval = false;
    private static boolean _runningWindows = false;
    private static boolean _logging = false;
    private static boolean _diag = false;
    private static String _ulibs = "libacme,libacuterm,libvision,libclnt,libaxml,libsrvmgmt,libruncbl";
    private static String _wlibs = "acme,atermmgr,avision5,libexpat,axml32,wrun32";
    private static String[] _libs = null;
    private static String _libext = null;
    private static String _logprops = "logging.properties";
    private static String _config = null;
    private static String _libloc = ".";
    private static String[] _localArgs = null;
    private static String _rt = "runcbl";
    private static Logger _log = null;
    private static Level _tracelevel = Level.OFF;
    private static Properties _configprops = null;
    private static Properties _options = null;

    public static void main(String[] stringArray) {
        runcbl.RunCbl(stringArray);
    }

    public static void RunCbl(String[] stringArray) {
        Object[] objectArray = new Object[]{};
        runcbl.RunCbl(stringArray, objectArray);
    }

    public static void RunCbl(String[] stringArray, Object[] objectArray) {
        runcbl.preinit();
        runcbl.parsecmdline(stringArray);
        runcbl.postinit();
        runcbl.loadlibs();
        runcbl.callprog(objectArray);
        if (!_retval) {
            try {
                _localArgs[0] = _localArgs[0] + _rt;
                Process process = Runtime.getRuntime().exec(_localArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void callprog(Object[] objectArray) {
        try {
            _retval = false;
            CVM.setupJVMExt();
            if (_options != null && _localArgs != null && CVM.acu_initvExt(_options, _localArgs) != 0) {
                runcbl._message("acu_initv complete", Level.INFO);
                _retval = true;
            }
            StatusInfo statusInfo = new StatusInfo();
            _options.setProperty("program.name", _localArgs[_localArgs.length - 1]);
            _retint = CVM.acu_cobolExt(_options, objectArray, statusInfo);
            CVM.acu_unload_allExt();
            CVM.acu_shutdownExt(0);
            _retval = true;
        }
        catch (Exception exception) {
            _retval = false;
        }
    }

    private static void preinit() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("os.name");
        if ((string = string.toLowerCase()).indexOf("windows") >= 0) {
            _runningWindows = true;
            _rt = "wrun32";
            _libs = _wlibs.split("[,;]");
        } else {
            _runningWindows = false;
            _libs = _ulibs.split("[,;]");
        }
        _options = new Properties();
        _options.setProperty("os.name", string);
        _options.setProperty("display", "-d");
        _options.setProperty("tty", "");
        _options.setProperty("debug", "0");
        _options.setProperty("cache", "0");
        _options.setProperty("num.params", "0");
        _options.setProperty("signal.number", "0");
        _options.setProperty("no.stop", "1");
    }

    private static void postinit() {
        if (_logging) {
            try {
                System.setProperty("java.util.logging.config.file", _logprops);
                _log = Logger.getLogger("com.acucorp.acucobolgt.runcbl");
                _log.setLevel(_tracelevel);
            }
            catch (Exception exception) {
                _log = null;
                _logging = false;
                System.out.println("Log not intialized; logging turned off.");
            }
        }
        if (_diag) {
            try {
                String string;
                Properties properties = null;
                Map<String, String> map = null;
                Map.Entry<String, String> entry2 = null;
                Iterator<Map.Entry<String, String>> iterator = null;
                Enumeration<?> enumeration = null;
                Set<Map.Entry<String, String>> set = null;
                runcbl._message("******************** Environment ********************", Level.CONFIG);
                map = System.getenv();
                set = map.entrySet();
                for (Map.Entry<String, String> entry2 : set) {
                    runcbl._message("ENV PROP: [" + entry2.getKey() + "] ENV VALUE: [" + entry2.getValue() + "]", Level.CONFIG);
                }
                runcbl._message("\n", Level.CONFIG);
                runcbl._message("******************** System Properties ********************", Level.CONFIG);
                properties = System.getProperties();
                enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    string = enumeration.nextElement().toString();
                    runcbl._message("PROPERTY: [" + string + "] VALUE: [" + properties.getProperty(string) + "]", Level.CONFIG);
                }
                runcbl._message("\n", Level.CONFIG);
                if (_config != null) {
                    FileInputStream fileInputStream = new FileInputStream(_config);
                    _configprops = new Properties();
                    _configprops.load(fileInputStream);
                    runcbl._message("******************** Config file ********************", Level.CONFIG);
                    enumeration = _configprops.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        string = enumeration.nextElement().toString();
                        runcbl._message("CONFIG VARIABLE: [" + string + "] VALUE: [" + _configprops.getProperty(string) + "]", Level.CONFIG);
                    }
                    runcbl._message("\n", Level.CONFIG);
                }
            }
            catch (Exception exception) {
                runcbl._message("unable to load config file", Level.CONFIG);
                exception.printStackTrace();
            }
        }
    }

    private static void loadlibs() {
        try {
            if (_libs == null || _libloc == null) {
                return;
            }
            String string = null;
            FileInputStream fileInputStream = null;
            for (int i = 0; i < _libs.length; ++i) {
                string = _libext == null ? _libloc + System.mapLibraryName(_libs[i]) : _libloc + _libs[i] + _libext;
                runcbl._message("loading: " + string, Level.CONFIG);
                try {
                    fileInputStream = new FileInputStream(string);
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    runcbl._message("lib not found: " + string, Level.CONFIG);
                    continue;
                }
                try {
                    System.load(string);
                }
                catch (Exception exception) {
                    runcbl._message("exc1 lib not loaded: " + string, Level.CONFIG);
                    try {
                        System.loadLibrary(string);
                    }
                    catch (Exception exception2) {
                        runcbl._message("exc2 lib not loaded: " + string, Level.CONFIG);
                    }
                    continue;
                }
                runcbl._message("lib loaded: " + string, Level.CONFIG);
            }
        }
        catch (Exception exception) {
            runcbl._message("unable to find runtime lib", Level.CONFIG);
            exception.printStackTrace();
        }
    }

    private static void parsecmdline(String[] stringArray) {
        try {
            int n;
            if (stringArray.length == 0) {
                System.exit(1);
            }
            if (stringArray[0].equalsIgnoreCase("-v") || stringArray[0].equalsIgnoreCase("-vv") || stringArray[0].equalsIgnoreCase("-vvv")) {
                System.exit(0);
            }
            String string = new String("localhost");
            Object var2_3 = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            Object e = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            int n2 = 1;
            int n3 = 0;
            boolean bl = false;
            boolean bl2 = false;
            Vector<String> vector = new Vector<String>();
            vector.clear();
            Vector<String> vector2 = new Vector<String>();
            vector2.clear();
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].startsWith("--")) {
                    if (stringArray[n].equalsIgnoreCase("--acugt")) {
                        if (n + 1 > stringArray.length) {
                            throw new IllegalArgumentException("incompleteArgument: " + stringArray[n]);
                        }
                        if ((_libloc = stringArray[++n]).endsWith(System.getProperty("file.separator"))) continue;
                        _libloc = _libloc + System.getProperty("file.separator");
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--embedded-config-file")) {
                        vector2.add(new String("--embedded-config-file"));
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--no-acusw")) {
                        vector2.add(new String("--no-acusw"));
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--no-save-debug")) {
                        vector2.add(new String("--no-save-debug"));
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--no-signal-handlers")) {
                        vector2.add(new String("--no-signal-handlers"));
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--time")) {
                        vector2.add(new String("--time"));
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--log")) {
                        _logging = true;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--logfile")) {
                        _logprops = stringArray[++n];
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--libs")) {
                        _libs = stringArray[++n].split("[,;]");
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--libext")) {
                        _libext = stringArray[++n];
                        continue;
                    }
                    if (!stringArray[n].equalsIgnoreCase("--verbose")) continue;
                    _diag = true;
                    continue;
                }
                if (stringArray[n].startsWith("+")) {
                    if (!stringArray[n].equalsIgnoreCase("+o")) continue;
                    string9 = stringArray[++n];
                    continue;
                }
                if (!stringArray[n].startsWith("-")) break;
                if (stringArray[n].length() > 2) {
                    if (stringArray[n].contains("d")) {
                        bl = true;
                    }
                    if (stringArray[n].contains("l")) {
                        bl2 = true;
                    }
                    if (stringArray[n].contains("x")) {
                        vector2.add(new String("-x"));
                    }
                    if (!stringArray[n].contains("e")) continue;
                    string3 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-p")) {
                    n3 = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-m")) {
                    n2 = Integer.parseInt(stringArray[++n]);
                    string4 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-#")) {
                    string5 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-s")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-c")) {
                    _config = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-e")) {
                    string3 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-d")) {
                    bl = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-u")) {
                    string2 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-i")) {
                    string11 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-k")) {
                    string10 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-x")) {
                    vector2.add(new String("-x"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-l")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-b")) {
                    vector2.add(new String("-b"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-f")) {
                    vector2.add(new String("-f"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-g")) {
                    vector2.add(new String("-g"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-h")) {
                    vector2.add(new String("-h"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-import")) {
                    vector2.add(new String("-import"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-p")) {
                    vector2.add(new String("-p"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-p0")) {
                    vector2.add(new String("-p0"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-s")) {
                    vector2.add(new String("-s"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-u")) {
                    vector2.add(new String("-u"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-v")) {
                    vector2.add(new String("-v"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-vv")) {
                    vector2.add(new String("-vv"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-vvv")) {
                    vector2.add(new String("-vvv"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-w")) {
                    vector2.add(new String("-w"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-o")) {
                    string8 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-r")) {
                    string7 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-y")) {
                    string6 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-z")) {
                    vector2.add(new String("-z"));
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-t")) {
                    if (n + 1 == stringArray.length) {
                        _tracelevel = Level.SEVERE;
                        continue;
                    }
                    try {
                        int n4 = Integer.parseInt(stringArray[n + 1]);
                        n4 = n4 > 8 ? 8 : n4;
                        switch (n4) {
                            case 0: {
                                _tracelevel = Level.OFF;
                                break;
                            }
                            case 1: {
                                _tracelevel = Level.SEVERE;
                                break;
                            }
                            case 2: {
                                _tracelevel = Level.WARNING;
                                break;
                            }
                            case 3: {
                                _tracelevel = Level.INFO;
                                break;
                            }
                            case 4: {
                                _tracelevel = Level.CONFIG;
                                break;
                            }
                            case 5: {
                                _tracelevel = Level.FINE;
                                break;
                            }
                            case 6: {
                                _tracelevel = Level.FINER;
                                break;
                            }
                            case 7: {
                                _tracelevel = Level.FINEST;
                                break;
                            }
                            case 8: {
                                _tracelevel = Level.ALL;
                            }
                        }
                        ++n;
                    }
                    catch (NumberFormatException numberFormatException) {
                        _tracelevel = Level.SEVERE;
                    }
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("-w")) continue;
                throw new IllegalArgumentException("unknownArgument: " + stringArray[n]);
            }
            vector.add(_libloc);
            if (bl) {
                vector.add(new String("-d"));
            }
            if (bl2) {
                vector.add(new String("-l"));
            }
            if (_config != null) {
                vector.add(new String("-c"));
                vector.add(_config);
            }
            if (string3 != null) {
                vector.add(new String("-e"));
                vector.add(string3);
            }
            if (string5 != null) {
                vector.add(new String("-#"));
                vector.add(string5);
            }
            if (string11 != null) {
                vector.add(new String("-i"));
                vector.add(string11);
            }
            if (string10 != null) {
                vector.add(new String("-k"));
                vector.add(string10);
            }
            if (string9 != null) {
                vector.add(new String("+o"));
                vector.add(string9);
            }
            if (string8 != null) {
                vector.add(new String("-o"));
                vector.add(string8);
            }
            if (string7 != null) {
                vector.add(new String("-r"));
                vector.add(string7);
            }
            if (e != null) {
                vector.add(new String("-t"));
                vector.add((String)e);
            }
            if (string6 != null) {
                vector.add(new String("-y"));
                vector.add(string6);
            }
            if (string4 != null) {
                vector.add(new String("-m"));
                vector.add(Integer.toString(n2));
                vector.add(string4);
            }
            vector.addAll(vector2);
            while (n < stringArray.length) {
                vector.add(stringArray[n++]);
            }
            _localArgs = new String[vector.size()];
            vector.toArray(_localArgs);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static synchronized void WriteExceptiontoLog(Exception exception) {
        if (_logging && _log != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.close();
            _log.info(stringWriter.toString());
        }
    }

    private static synchronized void _error(String string) {
        String string2 = Thread.currentThread().getName();
        String string3 = String.format("%s - thread: %s", string, string2);
        if (_logging && _log != null) {
            _log.log(Level.WARNING, string3);
        } else {
            System.err.println(string3);
        }
    }

    private static synchronized void _message(String string, Level level) {
        String string2 = Thread.currentThread().getName();
        String string3 = String.format("%s - thread: %s", string, string2);
        if (_logging && _log != null) {
            _log.log(level, string3);
        } else {
            System.out.println(string3);
        }
    }
}

