#!/bin/sh
#
# Copyright (C) 2009-2014 Micro Focus. All rights reserved.
#
# ======================================================================
# =  addfile.sh
# =
# =  Usage: 
# =    addfile.sh [-d catalog_directory] [-x xfd_directory] [-u user] filename
# =    addfile.sh [-d catalog_directory] [-x xfd_directory] [-u user] -f listfile
# =        -d  specifies optional directory name to use for the
# =            System Catalog
# =        -x  specifies optional directory name to use for the
# =            XFD files
# =        -u  table owner
# =        -f  listfile
# =  Import an xfd file  or list of xfd files into the system catalog
# =
# =
# ======================================================================


# ======================================================================
# =
# =  Set up default values
# =
# ======================================================================

. ${GENESIS_HOME}/bin/axset.sh


while [ "$#" -gt "0" ]
do
	case "$1" in
		"-d")
			shift
			XDBC_CAT=$1
			shift
			;;
		"-f")
			shift
			XDBC_LIST=$1
			shift
			;;
		"-x")
			shift
			XDBC_XFD=$1
			shift
			;;
		"-u")
			shift
			XDBC_SCHEMA="-o $1"
			shift
			;;
		"-h")
			break
			;;
		"-help")
			break
			;;
		*)
			if [ "$#" = 1 ]; then
				XDBC_FILE=$1
			fi
			break
			;;
	esac
done

if   [ -n "${XDBC_LIST}"  ]; then
	"${XDBC_BIN}"xdbcutil -z -d ${XDBC_CAT} -x ${XDBC_XFD} ${XDBC_SCHEMA} -v -f ${XDBC_LIST}
elif [ -n "${XDBC_FILE}"  ]; then
	"${XDBC_BIN}"xdbcutil -z -d ${XDBC_CAT} -x ${XDBC_XFD} ${XDBC_SCHEMA} -v -a ${XDBC_FILE}
else
	echo ""
	echo  Usage: 
	echo "       "addfile.sh [-d catalog_directory] [-x xfd_directory] [-u user] filename
	echo "       "addfile.sh [-d catalog_directory] [-x xfd_directory] [-u user] -f file_list
	echo ""
fi

# ======================================================================
# =
# =     End addfile.sh
# =
# ======================================================================
