#!/bin/sh
#
# Copyright (C) 2009-2014 Micro Focus. All rights reserved.
#
# ======================================================================
# =  ainit.sh
# =
# =  ainit.sh [-d System_Catalog_directory]
# =     -d  specifies optional directory name to use for the
# =         System Catalog.
# =
# =     Create the AcuXDBC System Catalog with user/group table.
# =     An optional argument allows for the specification of where
# =     the new Systems Catalog should be created.
# =
# =     This script will also create the INFORMATION_SCHEMA views
# =     for accessing information about the tables in the System
# =     catalog.
# =
# ======================================================================


# ======================================================================
# =
# =  Set up default values
# =
# ======================================================================

. ${GENESIS_HOME}/bin/axset.sh


XDBC_PROCESS=1

while [ "$#" -gt "0" ]
do
        case "$1" in
                "-d")
                        shift
                        XDBC_CAT=$1
                        shift
                        ;;
                "-h")
                        shift
                        XDBC_PROCESS=
                        break
                        ;;
                "-help")
                        shift
                        XDBC_PROCESS=
                        break
                        ;;
                *)
                        shift
                        break
                        ;;
        esac
done

#
# Create the metadata repository with user/group catalog
#
#
if [ -n "${XDBC_PROCESS}"  ]; then
        echo ""
	echo Creating System Catalog in "${XDBC_CAT}"
	"${XDBC_BIN}"xdbcutil -z -c -d "${XDBC_CAT}" -pa

        echo ""
        echo Creating Information Schema Views
        echo ""
	"${XDBC_BIN}"asql.sh -r "${XDBC_BIN}"cview.sql
        echo ""

else
        echo Usage: ainit.sh [-d System_Catalog_directory]
fi


# ======================================================================
# =
# =     End ainit.sh
# =
# ======================================================================

