#!/bin/sh
#
# Copyright (C) 2009-2014 Micro Focus. All rights reserved.
#
# ======================================================================
# =  asql.sh
# =
# =  Command line SQL processor
# =  Usage: asql.sh [-c config] [-u user] [-p password] [-r script]
# =        -c  specifies configuration file in GENESIS_HOME
# =        -u  specifies user name
# =        -p  specifies password
# =        -r  specifies script file to run
# =        -s  specifies server to connect to
# =        -n  specifies port to connect to ( used only with remote server )
# =
# =
# ======================================================================


# ======================================================================
# =
# =  Set up default values
# =
# ======================================================================

. ${GENESIS_HOME}/bin/axset.sh

# ======================================================================
# show usage
# ======================================================================

show_usage()
{

	echo "Usage: asql.sh [-c config] [-u user] [-p password] [-r script]"
	echo "                [-s server] [-n port]"

}


# ======================================================================
# run sql commands locally
# ======================================================================

run_local()
{

	"${XDBC_BIN}"xdbcquery /z /cacuxdbc04:"${ASQLUSER}"/"${ASQLPSWD}"/xvision:"${XDBC_CNAME}" "${XDBC_SCRPT}"

}

# ======================================================================
# run sql commands remotely
# ======================================================================

run_remote()
{

	"${XDBC_BIN}"xdbcquery /z /cacuxdbc03:"${ASQLUSER}"/"${ASQLPSWD}"/xvision:"${XDBC_CNAME}"@"${XDBC_PORT}":"${XDBC_SERVER}"!acuxdbc04

}

# ======================================================================
# startup routine
# ======================================================================

do_startup()
{
# echo XDBC_SERVER=["${XDBC_SERVER}"]
if [ "${XDBC_SERVER}" = ""  ]; then
	run_local
else
	run_remote
fi

}

XDBC_PROCESS=1

while [ "$#" -gt "0" ]
do
        case "$1" in
                "-c")
                        shift
                        XDBC_CNAME=$1
                        shift
                        ;;
                "-u")
                        shift
                        ASQLUSER=$1
                        shift
                        ;;
                "-p")
                        shift
                        ASQLPSWD=$1
                        shift
                        break
                        ;;
                "-r")
                        shift
                        XDBC_SCRPT=$1
                        shift
                        ;;
                "-s")
                        shift
                        XDBC_SERVER=$1
                        shift
                        ;;
                "-n")
                        shift
                        XDBC_PORT=$1
                        shift
                        ;;
                "-h")
                        shift
			XDBC_PROCESS=
                        break
                        ;;
                "-help")
                        shift
			XDBC_PROCESS=
                        break
                        ;;
                *)
                        shift
                        break
                        ;;
        esac
done

if [ -n "${XDBC_SCRPT}" ]; then
	XDBC_SCRPT="/r""${XDBC_SCRPT}"
fi

if [ -n "${XDBC_PROCESS}"  ]; then
	do_startup
else
	show_usage
fi

# ======================================================================
# =
# =     End asql.sh
# =
# ======================================================================
