#
# Copyright (C) 2009-2014 Micro Focus. All rights reserved.
#
# ======================================================================
# =  axset.sh
# =     Allow custom configuration of AcuXDBC settings.
# =
# ======================================================================


# ======================================================================
# =
# =  You can set your own default config file name
# =  here.  For example:
# =      XDBC_CNAME=myconfig.txt
# =
# ======================================================================

XDBC_CNAME=acuxdbc.cfg
export MFDBC_CNAME

# ======================================================================
# =
# =  You can set your own default login and password here.  These
# =  variables are used for mfsql to connect to the database.
# =
# ======================================================================

ASQLUSER=system
ASQLPSWD=manager
ASQLDSN=MFDBC

export ASQLUSER ASQLPSWD ASQLDSN

# ======================================================================
# =
# =  You can set your own default schema to load files into
# =  here.  If set to nothing, files will be added to the PUBLIC schema.
# =
# =  For example:
# =      XDBC_SCHEMA=scott
# =
# =
# ======================================================================

XDBC_SCHEMA=
export XDBC_SCHEMA

XDBC_DIR=${GENESIS_HOME}
export XDBC_DIR

# ======================================================================
# =
# =  You can set your own directory for the AcuXDBC scripts and
# =  executables.
# =  For example:
# =      XDBC_BIN=/home/user1/bin/
# =
# ======================================================================

XDBC_BIN=${XDBC_DIR}/bin/
export XDBC_BIN

# ======================================================================
# =
# =  You can set your own default system catalog directory
# =  here.  For example:
# =      XDBC_CAT=/home/user1/mycat
# =
# =
# ======================================================================

XDBC_CAT=${XDBC_DIR}/syscat
export XDBC_CAT

# ======================================================================
# =
# =  You can set your own default data directory
# =  here.  This will be where new files are created.  It should
# =  be the first item listed in your acuxdbc.cfg file.
# =  For example:
# =      XDBC_DATA=/home/user1/data
# =
# =
# ======================================================================

XDBC_DATA=${XDBC_DIR}/data
export XDBC_DATA

# ======================================================================
# =
# =  You can set your own default demo directory
# =  here.  For example:
# =      XDBC_DEMO=/home/user1/sample
# =
# ======================================================================

XDBC_DEMO=${XDBC_DIR}/sample/acuxdbc
export XDBC_DEMO

# ======================================================================
# =
# =  You can set your own default port to use
# =  For example:
# =      set XDBC_PORT=6524
# =
# =
# ======================================================================

XDBC_PORT=20222
export XDBC_PORT

# ======================================================================
# =
# =  You can set your own default server to use
# =  For example:
# =      set XDBC_SERVER=myserver
# =
# =
# ======================================================================

XDBC_SERVER=
export XDBC_SERVER

# ======================================================================
# =
# =  You can set your own default encryption key
# =  For example:
# =      set XDBC_KEY= -k1
# =
# =  Note that clients must have the same value in their net.ini file
# =
# ======================================================================

XDBC_KEY=
export XDBC_KEY

XDBC_PREFIX="${XDBC_DIR}/data;${XDBC_DEMO}/data"
export XDBC_PREFIX

XDBC_XFD=./
XDBC_FILE=
XDBC_LIST=
XDBC_SCRPT=

export XDBC_XFD XDBC_FILE XDBC_LIST XDBC_SCRPT

# make newline-suppress portable (instead of assuming -n will work)
echo_n()
{
    # How can we echo without displaying a newline?
    if [ `echo -n "This is a test" | wc -l` = "0" ]; then
        n="-n"
        c=
    elif [ `echo "This is a test" \\\\c | wc -l` = "0" ]; then
        n=
        c="\\c"
    else
        n=
        c=
    fi

    echo $n "$*" $c
}

# ======================================================================
# =
# =     End axset.sh
# =
# ======================================================================


