#!/bin/sh
#
# Copyright (C) 2009-2014 Micro Focus. All rights reserved.
#
# ======================================================================
# =  demo.sh
# =
# =  demo.sh [-d System_Catalog_directory]
# =        -d  specifies optional directory name to use for the
# =            System Catalog
# =
# =     Load the AcuXDBC sample xfd files into a newly created
# =     Systems Catalog.  An optional argument allows for the
# =     specification of where the new Systems Catalog should be
# =     created.
# =
# =     This script will also create the INFORMATION_SCHEMA views
# =     for accessing information about the tables in the System
# =     catalog.
# =
# ======================================================================

# ======================================================================
# =
# =  Set up default values
# =
# ======================================================================

. ${GENESIS_HOME}/bin/axset.sh

# ======================================================================
# =
# =  Main logic
# =
# ======================================================================

XDBC_PROCESS=1

while [ "$#" -gt "0" ]
do
	case "$1" in
		"-d")
			shift
			XDBC_CAT=$1
			shift
			;;
		"-h")
			shift
			XDBC_PROCESS=
			break
			;;
		"-help")
			shift
			XDBC_PROCESS=
			break
			;;
		*)
			shift
			break
			;;
	esac
done

if [ -n "${XDBC_PROCESS}"  ]; then
	echo ""
	echo Building demo with the following settings
	echo ""
	echo Data Directory  = ${XDBC_DATA}
	echo System Catalog  = ${XDBC_CAT}
	echo Sample Data XFD = ${XDBC_DEMO}/xfd
	echo ""
	if [ ! -d "${XDBC_CAT}" ]; then
		echo Create SYSTEM CATALOG Directory "$XDBC_CAT"
		mkdir "${XDBC_CAT}"
	fi
	if [ ! -d "${XDBC_DATA}" ]; then
		echo Create Data Directory "$XDBC_DATA"
		mkdir "${XDBC_DATA}"
	fi
# ======================================================================
# =
# = Clean up from old install
# =
# ======================================================================

	for XDBC_CATFILE in  ls "${XDBC_CAT}"/GENESIS_*
	do
        	rm -f "${XDBC_CATFILE}"
	done

	rm -f  "${XDBC_DATA}"/SYSTEM?DUAL
	rm -f  "${XDBC_DATA}"/SYSTEM?DUAL.vix

# ======================================================================
# =
# =  Create System Catalog
# =
# ======================================================================

	echo ""
	echo Creating System Catalog
	echo ""
	"${XDBC_BIN}"/ainit.sh -d "${XDBC_CAT}"

# ======================================================================
# =
# =  Load sample table descriptions into
# =    the SYSTEM_CATALOG
# =
# ======================================================================
	echo ""
	echo Load Sample file descriptions
	echo ""
	"${XDBC_BIN}"/addfile.sh -d "${XDBC_CAT}" -x "${XDBC_DEMO}"/xfd -f "${XDBC_DEMO}"/demo_list.txt


else
	echo demo.sh [-d System_Catalog_directory]
fi

# ======================================================================
# =
# =     End demo.sh
# =
# ======================================================================
