#!/bin/sh
#
# Copyright (C) 2009-2014 Micro Focus. All rights reserved.
#
# ======================================================================
# =  genxconf.sh
# =     Generate configuration file
# =
# =  Usage:
# =
# =     genxconf.sh [-d directory] [-c catalog] [-p prefix] [-n config_name]
# =        -d  specifies optional directory name to use for
# =            GENESIS_HOME
# =        -c  specifies optional directory name to use for the
# =            System Catalog
# =
# =     Create the AcuXDBC configuration file
# =
# ======================================================================

set_directory()
{
	GENESIS_HOME=$1
	XDBC_DIR=$1
}

set_catalog()
{
	XDBC_CAT=$1
}

set_prefix()
{
	XDBC_PREFIX=";$1"
}

set_config()
{
	XDBC_CNAME=$1
}

build_config()
{
	TMPNAME="$XDBC_DIR/$XDBC_CNAME"
	echo "Creating file $TMPNAME"
#	echo "Catalog:     [$XDBC_CAT]"
#	echo "File Prefix: [$XDBC_PREFIX]"

echo "#---------------------------------------------------------------------" > ${TMPNAME}
echo "#  This is a sample AcuXDBC configuration file." >> ${TMPNAME}
echo "#  You should edit it to match your needs." >> ${TMPNAME}
echo "#" >> ${TMPNAME}
echo "#  Some of the following lines are commented out to show you the" >> ${TMPNAME}
echo "#  default values.  If you want to use a different value, then" >> ${TMPNAME}
echo "#  uncomment the line and change the value." >> ${TMPNAME}
echo "#---------------------------------------------------------------------" >> ${TMPNAME}
echo "" >> ${TMPNAME}
echo "" >> ${TMPNAME}
echo "#---------------------------------------------------------------------" >> ${TMPNAME}
echo "#---------------------- GENERAL SETUP OPTIONS ------------------------" >> ${TMPNAME}
echo "#---------------------------------------------------------------------" >> ${TMPNAME}
echo "" >> ${TMPNAME}

echo "#  The path to your system catalog directory. This is a required variable" >> ${TMPNAME}
echo  "" >> ${TMPNAME}
echo "dictsource ${XDBC_CAT}" >> ${TMPNAME}
echo "" >> ${TMPNAME}
echo "" >> ${TMPNAME}

echo "#  The path to your data files.  You must prepend the line with a semi-colon," >> ${TMPNAME}
echo "#  use either double backslashes (\"\\\\\") or forward slashes (\"/\")," >> ${TMPNAME}
echo "#  and separate your paths by semi-colons. This is a required variable." >> ${TMPNAME}
echo ""  >> ${TMPNAME}

echo "file_prefix ;${XDBC_PREFIX}" >> ${TMPNAME}
cat "${XDBC_DEMO}/acuxdbc.in" >> ${TMPNAME}


}

show_usage()
{

	echo ""
	echo Usage:
	echo "       genxconf [-d directory] [-c catalog] [-p prefix] [-n config_name]"
	echo ""

}

check_home()
{
	while [ "$#" -gt "0" ]
	do
		case "$1" in
			"-d")
				shift
				set_directory $1
				shift
				;;
			*)
				shift
				;;
		esac
	done
}

# ======================================================================
# =
# =  Main logic
# =
# ======================================================================

check_home $*

# ======================================================================
# =
# =  Set up default values
# =
# ======================================================================

if [ -z "$GENESIS_HOME" ]; then
        echo "Error: \$GENESIS_HOME is not set"
        exit 1
fi

. ${GENESIS_HOME}/bin/axset.sh

XDBC_PROCESS=1

while [ "$#" -gt "0" ]
do
	case "$1" in
		"-d")
			shift
			set_directory $1
			shift
			;;
		"-c")
			shift
			set_catalog $1
			shift
			;;
		"-p")
			shift
			set_prefix $1
			shift
			;;
		"-n")
			shift
			set_config $1
			shift
			;;
		*)
			show_usage
			XDBC_PROCESS=
			break
			;;
	esac
done
if [ -n "${XDBC_PROCESS}"  ]; then
	build_config
fi

# ======================================================================
# =
# =     End genxconf.sh
# =
# ======================================================================

