       identification division.
       program-id.      bench4gl.
       author.          Micro Focus.
       date-written.    11-Nov-95.

      *> Copyright (c) 1995-2014 by Micro Focus IP, Ltd.
      *> Users of Micro Focus Acu4GL and Micro Focus Database Connectors
      *> may freely use this file.

      *> This program performs various file I/O tests for benchmarking
      *> purposes.

      *> Users of extend should compile this program with the
      *> following command:

      *>        ccbl32 -Zx bench4gl.cbl
      *> or
      *>        ccbl -Zx bench4gl.cbl

      *> Users of Micro Focus COBOL should compile this program
      *> with the following command:

      *>        cobol bench4gl.cbl ;
      *> or
      *>        cob bench4gl.cbl

      *> The following configuration/environment variables are used:

      *> Var                  Default   Purpose
      *> -----------------    ---       ---------------------------------------
      *> running-totals         0       If 1, display running totals
      *> check-ctr            100       Number of ops to do between time checks
      *> load-idx1-seconds     30       Seconds to run "load idx1"
      *> read-idx1-seconds     10       Seconds to run "read idx1"
      *> skip-idx1-seconds     10       Seconds to run "skip idx1"
      *> updt-idx1-seconds     10       Seconds to run "update idx1"
      *> load-idx2-seconds     30       Seconds to run "load idx2"
      *> updt-idx2-seconds     10       Seconds to run "update idx2"

      $SET CREATEXFD
      $SET CALLFH(ACUFH)

       environment division.
       input-output section.
       file-control.
       select seq-1-file
           assign to disk "seq1"
           binary sequential
           status is seq-1-status.

       select idx-1-file
           assign to disk "idx1"
           organization is indexed
           access is dynamic
           record key is idx-1-key
           status is idx-1-status.

       select idx-2-file
           assign to disk "idx2"
           organization is indexed
           access is dynamic
           record key is idx-2-key
           alternate record key is idx-2-alt-key with duplicates
           status is idx-2-status.

       data division.
       file section.
       fd  seq-1-file.
       01  seq-1-record.
           03  seq-1-key                pic 9(10).
           03  seq-1-alt-key.
               05  seq-1-alt-key-a      pic x(30).
               05  seq-1-alt-key-b      pic 9(10).
           03  seq-1-body               pic x(50).

       fd  idx-1-file.
       01  idx-1-record.
           03  idx-1-key                pic x(10).
           03  idx-1-alt-key.
               05  idx-1-alt-key-a      pic x(30).
               05  idx-1-alt-key-b      pic x(10).
           03  idx-1-body               pic x(50).

       fd  idx-2-file.
       01  idx-2-record.
           03  idx-2-key                pic x(10).
           03  idx-2-alt-key.
               05  idx-2-alt-key-a      pic x(30).
               05  idx-2-alt-key-b      pic x(10).
           03  idx-2-body               pic x(50).

       working-storage section.
       77  dummy                        pic x(5).
       77  seq-1-status                 pic x(2).
           88  all-done                     value "10".
       77  idx-1-status                 pic x(2).
           88  start-successful             value "00".
       77  idx-2-status                 pic x(2).

       77  sync-time-1                  pic 9(8).
       77  sync-time-2                  pic 9(8).

      ***   menu variables.
       01  menu-option                  pic x.
           88  configure-test               values "C", "c".
           88  run-test                     values "R", "r".
           88  help-test                    values "H", "h".
           88  about-test                   values "A", "a".
           88  exit-test                    values "E", "e", "X", "x".

       77  check-diff                   pic 9(6) value 0.
       77  recs-writ-idx1               pic 9(7) value 0.
       77  recs-read-idx1               pic 9(7) value 0.
       77  recs-skip-idx1               pic 9(7) value 0.
       77  recs-writ-idx2               pic 9(7) value 0.
       77  recs-updt-idx1               pic 9(7) value 0.
       77  recs-updt-idx2               pic 9(7) value 0.
       01  test-finished-flag           pic 9 value 0.
           88  test-finished                  value 1 false 0.

       78  num-time-vars                      value 6.
       01  environment-values.
           03  running-totals-flag      pic x value "0".
               88  display-running-totals     value "1".
           03  check-ctr                pic 9(5) value 100.
           03  internal-ctr             pic 9(5) value 0.
           03  check-test-time          pic 9(5).
           03  test-message             pic x(40).
           03  time-values-literal.
               05  load-idx1-seconds    pic 9(5) value 30.
               05  read-idx1-seconds    pic 9(5) value 10.
               05  skip-idx1-seconds    pic 9(5) value 10.
               05  updt-idx1-seconds    pic 9(5) value 10.
               05  load-idx2-seconds    pic 9(5) value 30.
               05  updt-idx2-seconds    pic 9(5) value 10.
           03  time-values-table        pic 9(5)
                                        occurs 6 times.
           03  time-values-varnames-literal.
               05  load-idx1-seconds-name pic x(18)
                                              value "load-idx1-seconds".
               05  read-idx1-seconds-name pic x(18)
                                              value "read-idx1-seconds".
               05  skip-idx1-seconds-name pic x(18)
                                              value "skip-idx1-seconds".
               05  updt-idx1-seconds-name pic x(18)
                                              value "updt-idx1-seconds".
               05  load-idx2-seconds-name pic x(18)
                                              value "load-idx2-seconds".
               05  updt-idx2-seconds-name pic x(18)
                                              value "updt-idx2-seconds".
           03  time-values-varnames-table pic x(18)
                                          occurs 6 times
                                          indexed by time-idx.
       01 screen-vars.
          05  io-literal                pic x(9).
          05  io-iterations             pic zzzz9.
          05  io-time                   pic zzzz9.

       77  begin-time                   pic 9(8).
       01  begin-time-fields redefines begin-time.
           03  begin-hours              pic 9(2).
           03  begin-minutes            pic 9(2).
           03  begin-seconds            pic 9(2).
           03  begin-hundreths          pic 9(2).
       77  check-time                   pic 9(8).
       01  check-time-fields redefines check-time.
           03  check-hours              pic 9(2).
           03  check-minutes            pic 9(2).
           03  check-seconds            pic 9(2).
           03  check-hundreths          pic 9(2).

       77  key-value                    pic 9(10).
       01  alt-key-value.
           03  alt-key-value-a          pic 9(15) value 842765989876543.
           03  alt-key-value-b          pic 9(8) value 62305671.
           03  alt-key-value-c          pic 9(7) value 2639004.
       01  alt-key-value-1 redefines alt-key-value.
           03  alt-char occurs 30 times pic x.

      ***   This table comes from the realia benchmark.
      ***   It contains a file action code and a key to operate on.
      ***   The file action code is "i" for "insert", "u" for "update",
      ***   and "d" for "delete".  For inserts and updates, a
      ***   random alternate key is generated.  This table is used more
      ***   than once by modifying the third character of the key on
      ***   different passes through the table.

       01  update-table-values.
           03   pic x(7) value 'i000001'.
           03   pic x(7) value 'i000002'.
           03   pic x(7) value 'i000003'.
           03   pic x(7) value 'i000004'.
           03   pic x(7) value 'u000010'.
           03   pic x(7) value 'i000011'.
           03   pic x(7) value 'i000012'.
           03   pic x(7) value 'i000013'.
           03   pic x(7) value 'i000014'.
           03   pic x(7) value 'i000015'.
           03   pic x(7) value 'i000016'.
           03   pic x(7) value 'i000017'.
           03   pic x(7) value 'i000018'.
           03   pic x(7) value 'i000019'.
           03   pic x(7) value 'u000020'.
           03   pic x(7) value 'd000030'.
           03   pic x(7) value 'i000035'.
           03   pic x(7) value 'u000040'.
           03   pic x(7) value 'd000050'.
           03   pic x(7) value 'i000055'.
           03   pic x(7) value 'i000061'.
           03   pic x(7) value 'i000062'.
           03   pic x(7) value 'i000063'.
           03   pic x(7) value 'i000064'.
           03   pic x(7) value 'u000070'.
           03   pic x(7) value 'i000071'.
           03   pic x(7) value 'i000072'.
           03   pic x(7) value 'i000073'.
           03   pic x(7) value 'i000074'.
           03   pic x(7) value 'i000075'.
           03   pic x(7) value 'i000076'.
           03   pic x(7) value 'i000077'.
           03   pic x(7) value 'i000078'.
           03   pic x(7) value 'i000079'.
           03   pic x(7) value 'u000080'.
           03   pic x(7) value 'd000090'.
           03   pic x(7) value 'i000091'.
           03   pic x(7) value 'i000092'.
           03   pic x(7) value 'i000093'.
           03   pic x(7) value 'i000094'.
      *
           03   pic x(7) value 'i000301'.
           03   pic x(7) value 'i000302'.
           03   pic x(7) value 'i000303'.
           03   pic x(7) value 'i000304'.
           03   pic x(7) value 'u000310'.
           03   pic x(7) value 'i000311'.
           03   pic x(7) value 'i000312'.
           03   pic x(7) value 'i000313'.
           03   pic x(7) value 'u000320'.
           03   pic x(7) value 'i000324'.
           03   pic x(7) value 'i000325'.
           03   pic x(7) value 'i000326'.
           03   pic x(7) value 'i000327'.
           03   pic x(7) value 'i000328'.
           03   pic x(7) value 'i000329'.
           03   pic x(7) value 'd000330'.
           03   pic x(7) value 'd000340'.
           03   pic x(7) value 'u000350'.
           03   pic x(7) value 'i000351'.
           03   pic x(7) value 'i000352'.
           03   pic x(7) value 'i000361'.
           03   pic x(7) value 'i000362'.
           03   pic x(7) value 'i000363'.
           03   pic x(7) value 'i000364'.
           03   pic x(7) value 'u000370'.
           03   pic x(7) value 'i000371'.
           03   pic x(7) value 'i000372'.
           03   pic x(7) value 'i000373'.
           03   pic x(7) value 'u000380'.
           03   pic x(7) value 'i000384'.
           03   pic x(7) value 'i000385'.
           03   pic x(7) value 'i000386'.
           03   pic x(7) value 'i000387'.
           03   pic x(7) value 'i000388'.
           03   pic x(7) value 'i000389'.
           03   pic x(7) value 'd000390'.
           03   pic x(7) value 'i000391'.
           03   pic x(7) value 'i000392'.
           03   pic x(7) value 'i000393'.
           03   pic x(7) value 'i000394'.
      *
           03   pic x(7) value 'i000501'.
           03   pic x(7) value 'i000502'.
           03   pic x(7) value 'i000503'.
           03   pic x(7) value 'i000504'.
           03   pic x(7) value 'u000510'.
           03   pic x(7) value 'i000517'.
           03   pic x(7) value 'i000518'.
           03   pic x(7) value 'i000519'.
           03   pic x(7) value 'u000520'.
           03   pic x(7) value 'd000530'.
           03   pic x(7) value 'd000540'.
           03   pic x(7) value 'i000551'.
           03   pic x(7) value 'i000552'.
           03   pic x(7) value 'i000553'.
           03   pic x(7) value 'i000561'.
           03   pic x(7) value 'i000565'.
           03   pic x(7) value 'i000568'.
           03   pic x(7) value 'u000580'.
           03   pic x(7) value 'd000590'.
           03   pic x(7) value 'i000595'.
           03   pic x(7) value 'i000601'.
           03   pic x(7) value 'i000602'.
           03   pic x(7) value 'i000603'.
           03   pic x(7) value 'i000604'.
           03   pic x(7) value 'u000610'.
           03   pic x(7) value 'i000617'.
           03   pic x(7) value 'i000618'.
           03   pic x(7) value 'i000619'.
           03   pic x(7) value 'u000620'.
           03   pic x(7) value 'd000630'.
           03   pic x(7) value 'd000640'.
           03   pic x(7) value 'i000651'.
           03   pic x(7) value 'i000652'.
           03   pic x(7) value 'i000653'.
           03   pic x(7) value 'i000661'.
           03   pic x(7) value 'i000665'.
           03   pic x(7) value 'i000668'.
           03   pic x(7) value 'u000680'.
           03   pic x(7) value 'd000690'.
           03   pic x(7) value 'i000695'.
      *
           03   pic x(7) value 'i000701'.
           03   pic x(7) value 'i000702'.
           03   pic x(7) value 'i000703'.
           03   pic x(7) value 'i000704'.
           03   pic x(7) value 'u000720'.
           03   pic x(7) value 'u000730'.
           03   pic x(7) value 'i000731'.
           03   pic x(7) value 'i000732'.
           03   pic x(7) value 'i000733'.
           03   pic x(7) value 'd000740'.
           03   pic x(7) value 'i000742'.
           03   pic x(7) value 'i000744'.
           03   pic x(7) value 'i000745'.
           03   pic x(7) value 'i000746'.
           03   pic x(7) value 'i000748'.
           03   pic x(7) value 'i000751'.
           03   pic x(7) value 'd000760'.
           03   pic x(7) value 'u000780'.
           03   pic x(7) value 'd000790'.
           03   pic x(7) value 'i000795'.
           03   pic x(7) value 'i000801'.
           03   pic x(7) value 'i000802'.
           03   pic x(7) value 'i000803'.
           03   pic x(7) value 'i000804'.
           03   pic x(7) value 'u000820'.
           03   pic x(7) value 'u000830'.
           03   pic x(7) value 'i000831'.
           03   pic x(7) value 'i000832'.
           03   pic x(7) value 'i000833'.
           03   pic x(7) value 'd000840'.
           03   pic x(7) value 'i000842'.
           03   pic x(7) value 'i000844'.
           03   pic x(7) value 'i000845'.
           03   pic x(7) value 'i000846'.
           03   pic x(7) value 'i000848'.
           03   pic x(7) value 'i000851'.
           03   pic x(7) value 'd000860'.
           03   pic x(7) value 'u000880'.
           03   pic x(7) value 'd000890'.
           03   pic x(7) value 'i000895'.
      *
           03   pic x(7) value 'i000901'.
           03   pic x(7) value 'i000902'.
           03   pic x(7) value 'i000903'.
           03   pic x(7) value 'i000904'.
           03   pic x(7) value 'u000910'.
           03   pic x(7) value 'i000911'.
           03   pic x(7) value 'i000912'.
           03   pic x(7) value 'i000913'.
           03   pic x(7) value 'i000914'.
           03   pic x(7) value 'i000915'.
           03   pic x(7) value 'i000916'.
           03   pic x(7) value 'i000917'.
           03   pic x(7) value 'i000918'.
           03   pic x(7) value 'i000919'.
           03   pic x(7) value 'u000920'.
           03   pic x(7) value 'i000921'.
           03   pic x(7) value 'd000930'.
           03   pic x(7) value 'd000940'.
           03   pic x(7) value 'd000950'.
           03   pic x(7) value 'i000951'.
           03   pic x(7) value 'i000952'.
           03   pic x(7) value 'i000953'.
           03   pic x(7) value 'i000954'.
           03   pic x(7) value 'i000955'.
           03   pic x(7) value 'u000960'.
           03   pic x(7) value 'i000961'.
           03   pic x(7) value 'i000962'.
           03   pic x(7) value 'i000963'.
           03   pic x(7) value 'i000964'.
           03   pic x(7) value 'i000965'.
           03   pic x(7) value 'i000966'.
           03   pic x(7) value 'i000967'.
           03   pic x(7) value 'i000968'.
           03   pic x(7) value 'i000969'.
           03   pic x(7) value 'u000970'.
           03   pic x(7) value 'd000980'.
           03   pic x(7) value 'd000990'.
           03   pic x(7) value 'i000991'.
           03   pic x(7) value 'i000992'.
           03   pic x(7) value 'i000993'.

       01  update-table redefines update-table-values.
           03  update-entry occurs 200 times.
               05  update-code          pic x.
                   88  update-write         value "i".
                   88  update-rewrite       value "u".
                   88  update-delete        value "d".
               05  update-key.
                   07  filler           pic 9(2).
                   07  update-change    pic 9.
                   07  filler           pic 9(3).

       77  indx                         pic 9(4) comp-x.
       77  update-char                  pic 9.
       01  update-full-key.
           03  filler                   pic x(4) value zeros.
           03  update-short-key         pic x(6).

       screen section.
       01  menu-screen.
           03  blank screen.
           03  "bench4gl - an alternate benchmark" line 1 col 24.
           03  "C)onfigure" line 5 col 10.
           03  "R)un" line 6 col 10.
           03  "H)elp" line 7 col 10.
           03  "A)bout" line 8 col 10.
           03  "E)xit" line 9 col 10.
           03  "Option:" line 20 col 15.
           03  pic x using menu-option line 20 col 30.

       01  open-file.
           03  "opening files ......" erase eol line 20 col 10.

       01  files-opened.
           03  "opening files ......"           line 20 col 10.
           03  " done"                          col + 2.

       01  test-start-screen.
           05  blank screen.
           05  "Test" line 5 col 10.
           05  "I/O iterations" line 5 col 58.

       01  test-complete-screen.
           05  "Test complete - press <ENTER>" erase eol line 20 col 10.

       01  line-20 size 80.
           05  pic x(9) using io-literal              col + 10.
           05  pic z(4)9 using io-iterations          col + 1.
           05  "seconds"                              col + 10.
           05  pic z(4)9 using io-time                col + 3.

       01  display-time-screen.
           03  pic x(40) from test-message               column 1.
           03  pic z(4)9 from io-time                    column 40.
           03  "seconds."                                column 46.
           03  pic z(4)9 from io-iterations              column 60.

       01  configure-screen.
           05  blank screen.
           05  "load idx1 seconds:"                line   2 col 2.
           05  pic z(4)9 using load-idx1-seconds            col + 2.
           05  "read idx1 seconds:"                line + 1 col 2.
           05  pic z(4)9 using read-idx1-seconds            col + 2.
           05  "skip idx1 seconds:"                line + 1 col 2.
           05  pic z(4)9 using skip-idx1-seconds            col + 2.
           05  "updt idx1 seconds:"                line + 1 col 2.
           05  pic z(4)9 using updt-idx1-seconds            col + 2.
           05  "load idx2 seconds:"                line + 1 col 2.
           05  pic z(4)9 using load-idx2-seconds            col + 2.
           05  "updt idx2 seconds:"                line + 1 col 2.
           05  pic z(4)9 using updt-idx2-seconds            col + 2.

       01  help-screen.
           03  blank screen.
           03  "Time parameters for benchmarks are set" line 2 col 2.
           03  "in configuration file entries:"         line + 1 col 2.
           03  pic x(18) from load-idx1-seconds-name    line + 1 col 2.
           03  "(for load idx1 time)"                   col + 1.
           03  pic x(18) from read-idx1-seconds-name    line + 1 col 2.
           03  "(for read idx1 time)"                   col + 1.
           03  pic x(18) from skip-idx1-seconds-name    line + 1 col 2.
           03  "(for skip idx1 time)"                   col + 1.
           03  pic x(18) from updt-idx1-seconds-name    line + 1 col 2.
           03  "(for updt idx1 time)"                   col + 1.
           03  pic x(18) from load-idx2-seconds-name    line + 1 col 2.
           03  "(for load idx2 time)"                   col + 1.
           03  pic x(18) from updt-idx2-seconds-name    line + 1 col 2.
           03  "(for updt idx2 time)"                   col + 1.
           03  "These parameters can be changed via"    line + 2 col 2.
           03  "the 'Configure' menu entry"             line + 1 col 2.
           03  "Select 'Run' to execute the benchmark"  line + 2 col 2.
           03  "with the desired time parameters."      line + 1 col 2.
           03  "Select 'Exit' to leave the program."    line + 2 col 2.

       01  about-screen.
           03  blank screen.
           03  "bench4gl version 1.0.0"                 line 2 col 2.
           03  "Author: Bob Cavanagh"                   line + 1 col 2.
           03  "November 11, 1995"                      line + 1 col 2.

       01  exit-screen.
           03  blank screen.
           03  "bench4gl version 1.0.0"                 line 2 col 2.
           03  "Thanks for stopping by"                 line + 2 col 2.

       procedure division.
       declaratives.
       seq-1-err-handling section.
           use after standard error procedure on seq-1-file.
       seq-1-err.
           display "*** file error #", line 23, erase screen,
                       seq-1-status, " on seq1 ***".
           display "*** test aborted ***".
           accept dummy.
           stop run.

       idx-1-err-handling section.
           use after standard error procedure on idx-1-file.
       idx-1-err.
           display "*** file error #", line 23, erase screen,
                       idx-1-status, " on idx1 ***".
           display "*** test aborted ***".
           accept dummy.
           stop run.

       idx-2-err-handling section.
           use after standard error procedure on idx-2-file.
       idx-2-err.
           display "*** file error #", line 23, erase screen,
                       idx-2-status, " on idx2 ***".
           display "*** test aborted ***".
           accept dummy.
           stop run.

       end declaratives.

       level-1 section.
       main-logic.
           accept running-totals-flag from environment "running_totals".

           display "Building sequential file - please wait..."
                   line 5 col 5.
           open output seq-1-file with lock.
           perform varying key-value from 10 by 10
                     until key-value is > 30000
               move key-value to seq-1-key, seq-1-alt-key-b
               move "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvw"
                               to seq-1-body
               perform generate-alt-key
               move alt-key-value to seq-1-alt-key-a
               write seq-1-record
           end-perform.
           close seq-1-file.
           display " done".

           perform until exit-test
               display menu-screen
               accept menu-screen
               perform evaluate-menu-selection
           end-perform.
           delete file seq-1-file.
           stop run.

       evaluate-menu-selection.
           evaluate true
             when configure-test
               display configure-screen
               accept configure-screen

             when run-test
               display test-start-screen

               perform load-idx-1-test
               perform read-idx-1-test
               perform skip-read-idx-1-test
               perform update-idx-1-test
               perform load-idx-2-test
               perform update-idx-2-test
               display test-complete-screen
               accept dummy

             when help-test
               display help-screen
               accept dummy

             when about-test
               display about-screen
               accept dummy

             when exit-test
               display exit-screen
               accept dummy
           end-evaluate.

       level-2 section.
       load-idx-1-test.
           move load-idx1-seconds to check-test-time.
           move "writes : " to io-literal.
           move "Load indexed file 1 (10-byte key)" to test-message.
           move 0 to io-iterations
                     recs-writ-idx1.
           move load-idx1-seconds to io-time.

           display open-file.
           open input seq-1-file with lock.
           open output idx-1-file with lock.
           display files-opened.

           display display-time-screen line 7.
           perform start-timer.
           read seq-1-file record.

           set test-finished to false.
           move 1 to internal-ctr.
           perform until test-finished or all-done
               write idx-1-record from seq-1-record
               add 1 to recs-writ-idx1
               perform test-internal-counter

               if display-running-totals
                   move recs-writ-idx1 to io-iterations
                   move check-diff to io-time
                   display line-20 line 20 col 1
               end-if

               read seq-1-file record
                 at end
                   set all-done to true
               end-read
           end-perform.

           move recs-writ-idx1 to io-iterations.
           move check-diff to io-time.
           display display-time-screen line 7.
           close seq-1-file, idx-1-file.

       read-idx-1-test.
           move read-idx1-seconds to check-test-time.
           move "reads  : " to io-literal.
           move "Read indexed file 1" to test-message.
           move 0 to io-iterations
                     recs-read-idx1.
           move read-idx1-seconds to io-time.

           display open-file.
           open input idx-1-file with lock.
           move zeroes to idx-1-key.
           start idx-1-file key > idx-1-key.
           display files-opened.

           display display-time-screen line 9.
           perform start-timer.
           set test-finished to false.
           move 1 to internal-ctr.
           perform until test-finished
               read idx-1-file next record
                 at end
                   set test-finished to true
                   move check-diff to io-time
                 not at end
                   add 1 to recs-read-idx1
                   perform test-internal-counter

                   if display-running-totals
                       move recs-read-idx1 to io-iterations
                       move check-diff to io-time
                       display line-20 line 20 col 1
                   end-if
               end-read
           end-perform.

           move recs-read-idx1 to io-iterations.
           move check-diff to io-time.
           display display-time-screen line 9.
           close idx-1-file.

       skip-read-idx-1-test.
           move skip-idx1-seconds to check-test-time.
           move "skips  : " to io-literal.
           move "Skip indexed file 1" to test-message.
           move 0 to io-iterations
                     recs-skip-idx1.
           move skip-idx1-seconds to io-time.

           display open-file.
           open input idx-1-file with lock.
           display files-opened.

           display display-time-screen line 11.
           perform start-timer.
           set test-finished to false.
           move 1 to internal-ctr.
           perform skip-read-idx-1-pass until test-finished.

           move recs-skip-idx1 to io-iterations.
           move check-diff to io-time.
           display display-time-screen line 11.
           close idx-1-file.

       skip-read-idx-1-pass.
           perform varying key-value from 0 by 10
                       until key-value is > 30000 or test-finished
               move key-value to idx-1-key

               perform until start-successful
                   start idx-1-file key not less than idx-1-key
                     invalid key
                       move "23" to idx-1-status
                       move zeroes to key-value
                       move key-value to idx-1-key
                   end-start
               end-perform

               read idx-1-file next record
                 at end
                   set test-finished to true
                 not at end
                   add 1 to recs-skip-idx1
                   perform test-internal-counter

                   if display-running-totals
                       move recs-skip-idx1 to io-iterations
                       move check-diff to io-time
                       display line-20 line 20 col 1
                   end-if
               end-read
           end-perform.

       update-idx-1-test.
           move updt-idx1-seconds to check-test-time.
           move "updates: " to io-literal.
           move "Update indexed file 1" to test-message.
           move 0 to io-iterations
                     recs-updt-idx1.
           move updt-idx1-seconds to io-time.

           display open-file.
           open i-o idx-1-file with lock.
           display files-opened.

           display display-time-screen line 13.
           perform start-timer.
           move 1 to internal-ctr.
           set test-finished to false.
           perform update-idx-1-set varying update-char from zero by 1
                   until update-char is > 2 or test-finished.
           close idx-1-file.

           move recs-updt-idx1 to io-iterations.
           move check-diff to io-time.
           display display-time-screen line 13.

       update-idx-1-set.
           perform varying indx from 1 by 1
                     until indx is > 200 or test-finished
               move update-char to update-change( indx )
               move update-key (indx) to update-short-key
               move update-full-key to idx-1-key,
                                       idx-1-alt-key-b
               move zeros to idx-1-body
               perform generate-alt-key
               move alt-key-value to idx-1-alt-key-a
               evaluate update-code (indx)
                 when "i"    write idx-1-record
                 when "u"    rewrite idx-1-record
                 when "d"    delete idx-1-file record
               end-evaluate
               add 1 to recs-updt-idx1
               perform test-internal-counter

               if display-running-totals
                   move recs-updt-idx1 to io-iterations
                   move check-diff to io-time
                   display line-20 line 20 col 1
               end-if
           end-perform.

       load-idx-2-test.
           move load-idx2-seconds to check-test-time.
           move "writes : " to io-literal.
           move "Load indexed file 2 (10/40-byte keys)" to test-message.
           move 0 to io-iterations
                     recs-writ-idx2.
           move load-idx2-seconds to io-time.

           display open-file.
           open input seq-1-file with lock.
           open output idx-2-file with lock.
           display files-opened.

           display display-time-screen line 15.
           perform start-timer.
           read seq-1-file record.
           move 1 to internal-ctr.
           set test-finished to false.
           perform until seq-1-status is not = "00" or test-finished
               write idx-2-record from seq-1-record
               read seq-1-file record
                 at end
                   continue
               end-read
               add 1 to recs-writ-idx2
               perform test-internal-counter

               if display-running-totals
                   move recs-writ-idx2 to io-iterations
                   move check-diff to io-time
                   display line-20 line 20 col 1
               end-if
           end-perform.

           close seq-1-file, idx-2-file.
           move recs-writ-idx2 to io-iterations.
           move check-diff to io-time.
           display display-time-screen line 15.

       update-idx-2-test.
           move updt-idx2-seconds to check-test-time.
           move "updates: " to io-literal.
           move "Update indexed file 2" to test-message.
           move 0 to io-iterations
                     recs-updt-idx2.
           move updt-idx2-seconds to io-time.

           display open-file.
           open i-o idx-2-file with lock.
           display files-opened.

           display display-time-screen line 17.
           perform start-timer.
           move 1 to internal-ctr.
           set test-finished to false.
           perform update-idx-2-set varying update-char from zero
                by 1 until update-char is > 2 or test-finished.
           close idx-2-file.

           move recs-updt-idx2 to io-iterations.
           move check-diff to io-time.
           display display-time-screen line 17.

       update-idx-2-set.
           perform varying indx from 1 by 1 until indx is > 200
                         or test-finished
               move update-char to update-change (indx)
               move update-key (indx) to update-short-key
               move update-full-key to idx-2-key,
                                       idx-2-alt-key-b
               move zeros to idx-2-body
               perform generate-alt-key
               move alt-key-value to idx-2-alt-key-a
               evaluate update-code (indx)
                 when "i"    write idx-2-record
                 when "u"    rewrite idx-2-record
                 when "d"    delete idx-2-file record
               end-evaluate
               add 1 to recs-updt-idx2
               perform test-internal-counter

               if display-running-totals
                   move recs-updt-idx2 to io-iterations
                   move check-diff to io-time
                   display line-20 line 20 col 1
               end-if
           end-perform.

       level-99 section.
       test-internal-counter.
           if internal-ctr >= check-ctr
               perform check-timer
               move 0 to internal-ctr
           end-if.
           add 1 to internal-ctr.

       generate-alt-key.
           multiply alt-key-value-b by alt-key-value-c
                                    giving alt-key-value-a.
           move alt-char(1) to alt-char(29).
           move alt-char(2) to alt-char(25).
           move alt-char(3) to alt-char(20).
           move alt-char(4) to alt-char(22).
           move alt-char(5) to alt-char(17).
           move alt-char(6) to alt-char(30).
           move alt-char(7) to alt-char(23).
           move alt-char(8) to alt-char(16).

       start-timer.
           accept sync-time-1 from time.
           perform with test after until sync-time-1 not = sync-time-2
               accept sync-time-2 from time
           end-perform.
           accept begin-time from time.

       check-timer.
           accept check-time from time.
           compute check-diff =
                    (check-hours - begin-hours) * 3600
                  + (check-minutes - begin-minutes) * 60
                  + (check-seconds - begin-seconds).

           if check-diff > check-test-time
               set test-finished to true
           end-if.
