       identification division.
       program-id.   order2-demo.

      *>    This program is an example of the application of directives to convert
      *>    an existing program for use with ACU4GL or Database Connectors
      *>    EXAMPLE #2

      *>    Suppose that you wanted both record formats to be placed into
      *>    the table.  This might be athe case if you intended to do any
      *>    work with a 4GL.  Add the WHEN directive in front of each
      *>    record, as shown below.  The WHEN directive can also be used
      *>    to include both definitions from a REDEFINES statement.

      $SET CREATEXFD

       environment division.
       configuration section.

       input-output section.
       file-control.

       select        p-o-file
               assign to disk "purch2"
               organization is indexed
               access mode is dynamic
               record key is p-o-number
               file status is p-o-status.

       data division.
       file section.

       fd  p-o-file.
      $xfd when p-o-record-type = "H"
       01  p-o-record.
           03  p-o-division-number                pic 9(3).
           03  p-o-record-type                    pic x.
               88  header-record                      value "H".
               88  detail-record                      value "D".
           03  p-o-number                         pic x(10).
           03  p-o-number-detail redefines p-o-number.
               05  picking-ticket-number          pic 9(6).
               05  shipping-region                pic 9(2).
               05  p-o-customer-type              pic 9(2).
               05  p-o-customer-breakdown redefines p-o-customer-type.
                   07  customer-category          pic x.
                       88  p-o-customer-retail        value "R".
                       88  p-o-customer-whlsale       value "W".
                   07  customer-pay-format        pic x.
                       88 is-net-30                   value "3".
                       88 is-net-10                   value "1".
           03  p-o-date.
               05  p-o-yy                         pic 9(2).
               05  p-o-mm                         pic 9(2).
               05  p-o-dd                         pic 9(2).
      * we could also use the "when other" directive here
      $xfd when p-o-record-type = "D"
       01  p-o-detail-record.
           03  p-o-dept-number                    pic 9(3).
           03  p-o-record-type                    pic x.
           03  detail-p-o-number                  pic x(10).
           03  p-o-shipping-info.
               05  p-o-quantity-to-ship           pic s9(4) comp.
               05  p-o-total-quantity             pic s9(4) comp.
           03  p-o-notes.
               05  notes-line occurs 3 times      pic x(40).


       working-storage section.

       01  p-o-status                             pic x(2).
       01  p-o-ext-stat                           pic x(7).
       01  p-o-errmsg                             pic x(80).
       01  end-of-file                            pic x.

       procedure division.

       level-1 section.
       main-logic.
           open output p-o-file.
           if p-o-status(1:1) = "9"
               *> Set tunable acu_library=true in order to call C$RERR
               *> This is only valid if Database Connectors is active
               *> and the error was an interface error in DBC.
               call "C$RERR" using p-o-ext-stat p-o-errmsg
               on exception
                   display "Unable to get extended error information "
                           "via C$RERR"
               not on exception
                   display "Error opening file: " p-o-ext-stat
                   display p-o-errmsg
               end-call
               stop run
           else
               if p-o-status not = "00"
                   display "File error " p-o-status " on file purch1"
                   stop run
               end-if
           end-if.
           perform write-hdr-record.
           perform write-dtl-record. 

           close p-o-file.
           stop run.

       write-hdr-record.
           move 001 to p-o-division-number.
           set header-record to TRUE.
           move 1111111111 to p-o-number.
           move 09 to p-o-yy.
           move 05 to p-o-mm.
           move 01 to p-o-dd.
           write p-o-record.
           display "Writing Header Record: ".
           display "   p-o-division-number: " p-o-division-number.
           display "   p-o-record-type: H".
           display "   p-o-number: " p-o-number.
           display "   p-o-date: " p-o-date.

       write-dtl-record.

           move 001 to p-o-dept-number.
           set detail-record to TRUE.
           move 1111111112 to detail-p-o-number.
           move 1 to p-o-quantity-to-ship.
           move 1 to p-o-total-quantity.
           move "notes line 1" to notes-line(1).
           move "notes line 2" to notes-line(2).
           move "notes line 3" to notes-line(3).
           write p-o-record.
           display "Writing Detail Record: ".
           display "   p-o-dept-number: " p-o-dept-number.
           display "   p-o-record-type: D".
           display "   detail-p-o-number: " detail-p-o-number.
           display "   p-o-quantity-to-ship: " p-o-quantity-to-ship.
           display "   p-o-total-quantity: " p-o-total-quantity.
           display "   notes-line 1: " notes-line(1).
           display "   notes-line 2: " notes-line(2).
           display "   notes-line 3: " notes-line(3).
