       identification division.
       program-id.    get-error.
       author.        Micro Focus IP, Ltd.

      *>  This program shows a method of retrieving the error
      *>  status in an independent manner.  Since it is based
      *>  on the internal error number, you do not need to worry
      *>  which set of file status codes you are using.
       
       data division.
       working-storage section.
       
      *> standard error values
       77  f-int-errno           pic s9(4) comp-5 external.
       77  f-errno               pic s9(4) comp-5 external.
           88  f-in-error            values 1 thru 99.
           88  e-sys-err             value 1.
           88  e-param-err           value 2.
           88  e-too-many-files      value 3.
           88  e-mode-clash          value 4.
           88  e-rec-locked          value 5.
           88  e-broken              value 6.
           88  e-duplicate           value 7.
           88  e-not-found           value 8.
           88  e-undef-record        value 9.
           88  e-disk-full           value 10.
           88  e-file-locked         value 11.
           88  e-rec-changed         value 12.
           88  e-mismatch            value 13.
           88  e-no-memory           value 14.
           88  e-missing-file        value 15.
           88  e-permission          value 16.
           88  e-no-support          value 17.
           88  e-no-locks            value 18.
           88  e-interface           value 19.
           88  w-no-support          value 100.
           88  w-dup-ok              value 101.
       
       01  error-text-strings.
           03  error-items.
               05  filler        pic x(20) value "System Error".
               05  filler        pic x(20) value "Parameter error".
               05  filler        pic x(20) value "Too many files".
               05  filler        pic x(20) value "Mode Clash".
               05  filler        pic x(20) value "Record Locked".
               05  filler        pic x(20) value "Broken File".
               05  filler        pic x(20) value "Duplicate Key".
               05  filler        pic x(20) value "Record Not Found".
               05  filler        pic x(20) value "Undefined Record".
               05  filler        pic x(20) value "Disk Full".
               05  filler        pic x(20) value "File Locked".
               05  filler        pic x(20) value "Record Changed".
               05  filler        pic x(20) value "Mismatch".
               05  filler        pic x(20) value "No Memory ".
               05  filler        pic x(20) value "Missing File".
               05  filler        pic x(20) value "Permission Error".
               05  filler        pic x(20) value "No Support".
               05  filler        pic x(20) value "No Locks".
               05  filler        pic x(20) value "Interface".
               05  filler        pic x(20) value "No Support".
               05  filler        pic x(20) value "Duplicates OK".
           03  error-table redefines error-items
               05  error-lit                occurs 21 times
                                 pic x(20).
       
       01  error-window          pic x(10).
       01  error-text            pic x(40).
       01  error-status.
           03  primary-error     pic x(2).
           03  extended-error    pic x(40).
       01  secondary-error       pic x(10).
       01  isam-error            pic x(40).
       
       screen section.
       01  error-screen.
           03  "COBOL Error:"      line 1    col 1.
           03  from error-lit (f-errno) bold col 20.
           03  "SECONDARY Error:"  line + 1  col 1.
           03  from secondary-error          col 20.
           03  "ISAM Error:"       line + 1  col 1.
           03  from error-text               col 20.
       
       procedure division.
       error-logic.
           if f-errno = 0
               exit program
           end-if.
           call "C$RERR" using error-status, error-text.
           unstring extended-error delimited by ","
                       into secondary-error, isam-error.
       
           display window line 8 column 10 size 60 lines 5
               centered title "ERROR"
               boxed pop-up area error-window.
           display error-screen.
           accept omitted.
           close window error-window.
           exit program.
