       identification division.
       program-id.    lockmgr.
       author.        Micro Focus IP, Ltd.
      *>               This program maintains the lock file for Acu4GL for Sybase
      *>               and Acu4GL for MSSQL.  It allows deleting all records that
      *>               have lockpid = some specified value, or viewing all records.

      *>               This program should be run with the same runtime and config
      *>               file as you normally use.  It automatically detects whether
      *>               Acu4GL for Sybase or MS SQL Server are available, and reads
      *>               the correct config variable to determine the name of the vision
      *>               file to manage.
      *>               This program is distributed as source to allow you to do
      *>               site-specific management if desired.

       environment division.
       input-output section.
       file-control.
       select lockfile assign to disk lockfilename
              organization is indexed
              access is dynamic
              record key is lockfile-key
              alternate record key is clean-locks =
                        lockfile-dbid,
                        lockfile-objid,
                        lockfile-lockpid
                        with duplicates
              status is lockfile-status.

       data division.
       file section.
       fd  lockfile.
       01  lockfile-rec.
           03  lockfile-key.
               05  lockfile-dbid       pic xx comp-n.
               05  lockfile-objid      pic xxxx comp-n.
               05  lockfile-keyvalue   pic x(244).
           03  lockfile-record.
               05  lockfile-lockpid    pic xxxx comp-n.
               05  lockfile-filenum    pic xxxx comp-n.

       working-storage section.
       78  do-sybase-value                 value 1.
       78  do-mssql-value                  value 2.
       77  key-status
           is special-names crt status pic 9(4).
           88  ok-button-pressed           value 10.

       01  screen-control
           is special-names screen control.
           03  accept-control          pic 9.
           03  control-value           pic 999.

       01  event-status
           is special-names event status.
           03  event-type              pic x(4) comp-x.
           03  event-window-handle     handle of window.
           03  event-control-handle    handle.
           03  event-control-id        pic xx comp-x.
           03  event-data-1            signed-short.
           03  event-data-2            signed-long.

       77  lockfilename                pic x(128).
       77  lockfile-status             pic xx.
       77  extended-status             pic x(10).
       77  io-creates                  pic x(10).
       77  state-flag                  pic x.
           88  reading-forwards            value "f".
           88  reading-backwards           value "b".
           88  at-start                    value "s".
           88  at-end                      value "e".
       77  interface-window            handle of window.
       77  interface-flag              pic 9 value do-sybase-value.
           88  do-sybase                   value do-sybase-value.
           88  do-mssql                    value do-mssql-value.
       77  sybase-flag                 pic x.
           88  have-sybase                 value "y" false "n".
       77  mssql-flag                  pic x.
           88  have-mssql                  value "y" false "n".

       77  popup-handle                handle of window.

       01  restrict-info.
           03  restrict-pid            signed-long value 0.
           03  restrict-pid-flag       pic 9 value 0.
               88  have-restrict-pid       value 1 false 0.
           03  restrict-dbid           signed-short value 0.
           03  restrict-dbid-flag      pic 9 value 0.
               88  have-restrict-dbid      value 1 false 0.
           03  restrict-objid          signed-long value 0.
           03  restrict-objid-flag     pic 9 value 0.
               88  have-restrict-objid     value 1 false 0.

       01  sel-idx                     signed-short.
       01  idx                         pic 999 comp.
       01  remove-all-flag             pic 9.
       01  list-data.
           03  list-dbid               pic -(5).
           03  list-objid              pic z(10).
           03  list-pid                pic z(10).
           03  filler                  pic xx value "0x".
           03  list-keyval             pic x(488).

       copy "../def/acugui.def".

       screen section.
       01  main-screen.
           03  label "Lock Manager"    line 1 col 30.
           03  label "DBID"            line 3 col 6.
           03  label "Object ID"       line 3 col 14.
           03  label "PID"             line 3 col 30.
           03  label "Key Value (HEX)" line 3 col 34.

           03  list-1, list-box using list-data, 3-d, line 4.5, col 5
                       size 70, lines 17,
                       data-columns = ( 1, 6, 16, 26 )
                       display-columns = ( 1, 7, 18, 29 )
                       alignment = ( "R", "R", "R", "L" )
                       separation = ( 3, 3, 3, 0 )
                       dividers = ( 2, 2, 2, 2 )
                       notify-selchange
                       notify-dblclick
                       exception procedure list-1-handler.

           03  pb-1 push-button, "Exit",
                    termination-value 10,
                    line 23, col 5.
           03  pb-2 push-button, "Restrict ...",
                    exception-value 3, size 12
                    line 23, col 20.
           03  pb-4 push-button, "Remove all",
                    exception-value 7, size 12
                    line 23, col 40.

       01  restrict-screen.
           03  check-box "Restrict by PID"
                       using restrict-pid-flag      line 2 col 5.
           03  entry-field using restrict-pid       line 2 col 27.
           03  check-box "Restrict by Object"
                       using restrict-objid-flag    line 4 col 5.
           03  entry-field using restrict-objid     line 4 col 27.
           03  check-box "Restrict by Database ID"
                       using restrict-dbid-flag     line 6 col 5.
           03  entry-field using restrict-dbid      line 6 col 27.
           03  push-button, ok-button               line 8 col 18.

       01  syb-or-mssql-screen.
           03  label "This runtime can access both Sybase and Microsoft 
      -              "SQL Server tables.  This program can only access a
      -              " single lock table at a time.  Please select the i
      -              "nterface for whose lock table you want to manage."
                     line 2 col 3 size 35 lines 7.
           03  radio-button "Sybase" using interface-flag line 8 col 5
               group-value = do-sybase-value.
           03  radio-button "MSSQL" using interface-flag line + 2 col 5
               group-value = do-mssql-value.
           03  push-button, ok-button     line + 3 col 20.
           03  push-button, cancel-button          col 30.

       procedure division.
       declaratives.
       lockfile-err-handling section.
           use after standard error procedure on lockfile.
       lockfile-err.
           display message box "*** FILE ERROR #", lockfile-status
                               " on LOCKFILE ***",
               title "Lockfile error"
               type = MB-OK
               icon = MB-ERROR-ICON.
           stop run.
       end declaratives.

       main-logic.
           display standard graphical window, size 80, lines 25,
                   background-low.
           set have-sybase, have-mssql to false.
           call "C$FILESYS" using 2, "SYBAS".
           if return-code = 1
               accept lockfilename from
                      environment "A_SYB_VISION_LOCKS_FILE"
               if lockfilename not = spaces
                   set have-sybase to true
               end-if
           end-if.
           call "C$FILESYS" using 2, "MSSQL".
           if return-code = 1
               accept lockfilename from
                      environment "A_MSSQL_VISION_LOCKS_FILE"
               if lockfilename not = spaces
                   set have-mssql to true
               else
                   if have-sybase
                       accept lockfilename from
                              environment "A_SYB_VISION_LOCKS_FILE"
                   end-if
               end-if
           end-if.
           if have-mssql and have-sybase
               display floating graphical window, size 40, lines 15,
                       background-low title "MSSQL or Sybase"
                       handle in interface-window
               display syb-or-mssql-screen
               accept syb-or-mssql-screen
               if key-status = 27                |cancel
                   stop run
               end-if
               if do_sybase
                   accept lockfilename from
                          environment "A_SYB_VISION_LOCKS_FILE"
               else
                   accept lockfilename from
                          environment "A_MSSQL_VISION_LOCKS_FILE"
               end-if
               close window interface-window
           end-if.
           if lockfilename = spaces
               display message box
                       "This runtime can access neither Sybase nor MSSQL
      -                " tables"
               stop run
           end-if.
           accept io-creates from environment "IO-CREATES".
           set environment "IO-CREATES" to "1".
           open i-o lockfile.
           set environment "IO-CREATES" to io-creates.
           display main-screen.
           perform load-list.
           perform until key-status = 10 or key-status = 10
               accept main-screen
               evaluate key-status
                 when 3
                   display floating window line 5 col 2
                           size 40 lines 10 boxed
                           title "Restrict shown locks"
                           handle popup-handle
                   perform until key-status = 13
                       display restrict-screen
                       accept restrict-screen
                   end-perform
                   destroy popup-handle
                   perform load-list

                 when 7
                   inquire list-1 selection-index in sel-idx
                   if sel-idx = -1
                       display message box
                               "This will remove all the items listed",
                               H"0A",
                               "Do you want to remove all listed items?"
                               title "Remove all shown locks?"
                               type MB-YES-NO-CANCEL
                               icon MB-WARNING-ICON
                               default MB-YES,
                               giving remove-all-flag
                       if remove-all-flag = MB-YES
                           move low-values to lockfile-rec
                           modify list-1 reset-list = 1
                           start lockfile key not < clean-locks
                             invalid key
                               exit paragraph
                           end-start
                           perform until lockfile-status = "10"
                               read lockfile next with no lock
                                 at end
                                   exit perform cycle
                                 not at end
                                   if (have-restrict-pid and
                                       restrict-pid not =
                                       lockfile-lockpid) or
                                      (have-restrict-objid and
                                       restrict-objid not =
                                       lockfile-objid) or
                                      (have-restrict-dbid and
                                       restrict-dbid not =
                                       lockfile-dbid)
                                       exit perform cycle
                                   end-if
                                   delete lockfile
                               end-read
                           end-perform
                       end-if
                   else
                       modify list-1 query-index = sel-idx,
                                     item-to-delete = sel-idx
                       inquire list-1 item-value in list-data
                       move list-dbid to lockfile-dbid
                       move list-objid to lockfile-objid
                       perform varying idx from 1 by 2 until idx > 244
                           call "hex2ascii" using
                                lockfile-keyvalue(idx:2),
                                list_keyval(2 * idx - 1:4)
                       end-perform
                       delete lockfile
                       modify list-1 selection-index = -1
                       modify pb-4 title = "Remove all"
                   end-if

                 when 10
                   exit perform cycle
               end-evaluate
           end-perform.
           close lockfile.
           stop run.

       load-list.
           move low-values to lockfile-rec.
           modify list-1 reset-list = 1.
           start lockfile key not < clean-locks
             invalid key
               exit paragraph
           end-start.
           modify list-1 mass-update = 1.
           perform until lockfile-status = "10"
               read lockfile next with no lock
                 at end
                   exit perform cycle
                 not at end
                   if (have-restrict-pid and
                       restrict-pid not = lockfile-lockpid) or
                      (have-restrict-objid and
                       restrict-objid not = lockfile-objid) or
                      (have-restrict-dbid and
                       restrict-dbid not = lockfile-dbid)
                       exit perform cycle
                   end-if
                   move lockfile-dbid to list-dbid
                   move lockfile-objid to list-objid
                   move lockfile-lockpid to list-pid
                   perform varying idx from 1 by 2 until idx > 244
                       call "ascii2hex" using
                            lockfile-keyvalue(idx:2),
                            list_keyval(2 * idx - 1:4)
                   end-perform
                   modify list-1 item-to-add = list-data
               end-read
           end-perform.
           modify list-1 mass-update = 0.

       list-1-handler.
           if key-status = w-event
               evaluate event-type
                 when ntf-selchange
                   modify pb-4 title = "Remove one"
                 when cmd-dblclick
                   modify list-1 selection-index = -1
                   modify pb-4 title = "Remove all"
               end-evaluate
           end-if
