       IDENTIFICATION DIVISION.
       PROGRAM-ID. animals.
       AUTHOR.  bbarr/jrodgers
       DATE-WRITTEN. 2002/10/28 PM 03:40.
       REMARKS.    Initial Version 6.0
           This program creates an XFD that can be used with an AcuODBC
           data source to test the basic directives in the AcuODBC manual:
           DATE, USE GROUP, READ-ONLY, NAME, NUMERIC, HIDDEN and WHEN to
           create 3 different tables (CATS, DOGS, OTHER_ANIMALS) in addition
           to the base, ANIMALS table.  

           An AcuODBC Data Source Name needs to be set up using ODBC Manager.
           The program needs to be compiled with an -Fa option 
           pointing to path for XFD creation.  The program needs a .cfg file
           to point to the file directory when creating or adding to the
           data file.

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT jr-file
              ASSIGN TO "animals"
              ORGANIZATION IS INDEXED
              ACCESS IS DYNAMIC
              RECORD KEY IS patient-id
              FILE STATUS IS jr-file-status.

       DATA DIVISION.
       FILE SECTION.
       FD  jr-file.
       01  jr-record.
           03  animal-info.
               05  patient-id                  pic 9(5).
               05  atype                       pic x.
               05  ctype redefines atype       pic x.
               05  dtype redefines atype       pic x.
               05  otype redefines atype       pic x.
           03  owner-info.
               05  phone                       pic x(8).
               05  owner                       pic x(30).
           03  financial.
               05  acct_no.
                   10  year                    pic 9(2).
                   10  seq_no                  pic 9(4).
               05  last_visit.
                   10  yyyy                    pic 9(4).
                   10  mm                      pic 9(2).
                   10  dd                      pic 9(2).
               05  fee                         pic s9(5)v99.
               05  date_paid                   pic 9(8). 


       WORKING-STORAGE SECTION.
           
       01  jr-file-status                      pic xx.

       PROCEDURE DIVISION.

       MAIN-LOGIC.

           open output jr-file.
           move "00001" to patient-id.
           move "C" to atype.
           move "555-0123" to phone.
           move "Robert Jones" to owner.
           move 85 to year.
           move 5678 to seq_no.
           move 20020521 to last_visit.
           move 60 to fee.
           move 20020602 to date_paid.
             write jr-record.

           move "00002" to patient-id.
           move "C" to atype.
           move "555-7777" to phone.
           move "Hartt Knox" to owner.
           move 96 to year.
           move 1370 to seq_no.
           move 20020421 to last_visit.
           move 105.55 to fee.
           move 20020517 to date_paid.
             write jr-record.

           move "00018" to patient-id.
           move "D" to atype.
           move "555-0904" to phone.
           move "Robert Michaels" to owner.
           move 01 to year.
           move 3174 to seq_no.
           move 20020608 to last_visit.
           move 13.25 to fee.
           move 20020608 to date_paid.
             write jr-record.

           move "00102" to patient-id.
           move "D" to atype.
           move "555-0145" to phone.
           move "Ellen Smith" to owner.
           move 94 to year.
           move 9012 to seq_no.
           move 20020617 to last_visit.
           move 200 to fee.
           move 20020721 to date_paid.
             write jr-record.

           move "00503" to patient-id.
           move "B" to atype.
           move "555-0167" to phone.
           move "Sam Tucker" to owner.
           move 95 to year.
           move 9876 to seq_no.
           move 20020508 to last_visit.
           move 90 to fee.
           move 20020508 to date_paid.
             write jr-record.

           move "00054" to patient-id.
           move "C" to atype.
           move "555-8832" to phone.
           move "Sidney Leonard" to owner.
           move 00 to year.
           move 7143 to seq_no.
           move 20020211 to last_visit.
           move 133.45 to fee.
           move 20020215 to date_paid.
             write jr-record.

           move "00160" to patient-id.
           move "D" to atype.
           move "555-6219" to phone.
           move "Neil Braziel" to owner.
           move 91 to year.
           move 5247 to seq_no.
           move 19980706 to last_visit.
           move 55.25 to fee.
           move 19980706 to date_paid.
             write jr-record.

           move "00480" to patient-id.
           move "T" to atype.
           move "555-1303" to phone.
           move "Buddy Green" to owner.
           move 97 to year.
           move 5430 to seq_no.
           move 20020129 to last_visit.
           move 98.25 to fee.
           move 20020220 to date_paid.
             write jr-record.

           move "00328" to patient-id.
           move "D" to atype.
           move "555-9921" to phone.
           move "Marcia Adams" to owner.
           move 02 to year.
           move 4319 to seq_no.
           move 20020314 to last_visit.
           move 28.70 to fee.
           move 20020314 to date_paid.
             write jr-record.

           move "00378" to patient-id.
           move "C" to atype.
           move "555-1011" to phone.
           move "Alix Parker" to owner.
           move 88 to year.
           move 6002 to seq_no.
           move 19991022 to last_visit.
           move 80.00 to fee.
           move 19991115 to date_paid.
             write jr-record.
                             
           move "00801" to patient-id.
           move "R" to atype.
           move "555-0198" to phone.
           move "Bob Hernandez" to owner.
           move 99 to year.
           move 1234 to seq_no.	
           move 20020523 to last_visit.
           move 25.75 to fee.
           move 20020523 to date_paid.
             write jr-record.

           move "00802" to patient-id.
           move "R" to atype.
           move "555-0198" to phone.
           move "Bob Hernandez" to owner.
           move 00 to year.
           move 2234 to seq_no.
           move 20020207 to last_visit.
           move 17.50 to fee.
           move 20020207 to date_paid.
             write jr-record.

           close jr-file.                 
           Exit Program.
           Stop Run.

