       IDENTIFICATION DIVISION.
       PROGRAM-ID. clients.
       AUTHOR.  bbarr/mkirschen/jrodgers
       DATE-WRITTEN. 2002/10/28 PM 03:15.
       REMARKS.    Initial Version 6.0
           [This program creates a file that can be used to demonstrate SQL syntax supported by AcuODBC:  SELECT, INSERT, DELETE, and UPDATE.

           An AcuODBC Data Source Name needs to be set up using ODBC Manager.
           The program needs to be compiled with an -Fxa and -Fo option 
           pointing to path for XFD creation.  The program needs a .cfg file
           to point to the file directory when creating or adding to the
           data file.]

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT jr-file
              ASSIGN TO "clients"
              ORGANIZATION IS INDEXED
              ACCESS IS DYNAMIC
              RECORD KEY IS client_id
              FILE STATUS IS jr-file-status.

       DATA DIVISION.
       FILE SECTION.
       FD  jr-file.
       01  jr-record.
           05  client_id                pic 9(5).
	   05  owner                   	pic x(30).	
           05  street                  	pic x(30).
           05  city                    	pic x(30).
           05  state_province		pic x(30).
           05  post_code                pic x(6).
           05  country                 	pic x(30).

       WORKING-STORAGE SECTION.
           
       01  jr-file-status               pic xx.

       PROCEDURE DIVISION.

       MAIN-LOGIC.

           open output jr-file.
           move "00624" to client_id.
           move "Robert Jones" to owner.	
           move "1234 10th Street" to street.
           move "San Diego" to city.
           move "California" to state_province.
           move "92121" to post_code.
           move "US" to country.
	     write jr-record.

           move "00600" to client_id.
           move "Ellen Smith" to owner.	
           move "5678 11th Street" to street.
	   move "Irvington" to city.
           move "New Jersey" to state_province.
           move "07111" to post_code.
           move "US" to country.
             write jr-record.
   
           move "00625" to client_id.
           move "Sam Tucker" to owner.	
           move "9012 12th Avenue" to street.
           move "Toronto" to city.
           move "Ontario" to state_province.
           move "M5J1A7" to post_code.
           move "Canada" to country.
             write jr-record.
              
           move "00550" to client_id.
           move "Hartt Knox" to owner.	
           move "3456 13th Boulevard" to street.
           move "Chicago" to city.
           move "Illinois" to state_province.
           move "60603" to post_code.
           move "US" to country.
             write jr-record.

           move "00700" to client_id.
           move "Bob Hernandez" to owner.	
           move "7890 14th Drive" to street.
           move "Oceanside" to city.
           move "California" to state_province.
           move "92049" to post_code.
           move "US" to country.
             write jr-record.

           move "00309" to client_id.           
           move "Buddy Green" to owner.	
           move "2468 10th Street" to street.
	   move "Winnipeg" to city.
           move "Manitoba" to state_province.
           move "R3B3E5" to post_code.
           move "Canada" to country.
             write jr-record.

           move "00221" to client_id.           
           move "Brian Davidson" to owner.	
           move "3579 First Street" to street.
           move "Phoenix" to city.
           move "Arizona" to state_province.
           move "85008" to post_code.
           move "US" to country.
             write jr-record.

           move "00618" to client_id.           
           move "Marcia Adams" to owner.	
           move "9876 A Street" to street.
           move "San Diego" to city.
           move "California" to state_province.
           move "92126" to post_code.
           move "US" to country.
             write jr-record.

           move "00357" to client_id.
           move "Alix Parker" to owner.
           move "761 Davis Street" to street.
           move "Phoenix" to city.
           move "Arizona" to state_province.
           move "85008" to post_code.
           move "US" to country.
             write jr-record.

           move "00377" to client_id.           
           move "Sidney Leonard" to owner.	
           move "1256 Cypress Street" to street.
           move "Tucson" to city.
           move "Arizona" to state_province.
           move "85001" to post_code.
           move "US" to country.
             write jr-record.

           move "00522" to client_id.
           move "Neil Braziel" to owner.
           move "334 Walnut Drive" to street.
           move "Halifax" to city.
           move "Nova Scotia" to state_province.
           move "B3J3P7" to post_code.
           move "Canada" to country.
             write jr-record.

           move "00704" to client_id.           
           move "Robert Michaels" to owner.	
           move "95 Westview Road" to street.
           move "San Diego" to city.
           move "California" to state_province.
           move "92121" to post_code.
           move "US" to country.
           write jr-record.

	     close jr-file.                 
           Exit Program.
           Stop Run.

