       IDENTIFICATION DIVISION.
       PROGRAM-ID. pets.
       AUTHOR.  bbarr
       DATE-WRITTEN. 2000/02/08 AM 09:35.
       REMARKS.    Initial Version 4.3.1
           This program creates an XFD that can be used with an AcuODBC
           data source to test the basic directives in the AcuODBC manual:
           DATE, USE GROUP, READ-ONLY, NAME, NUMERIC, HIDDEN and WHEN to
           create 3 different tables (CATS, DOGS, BIRDS) in addition
           to the base, ANIMALS table.  

           An AcuODBC Data Source Name needs to be set up using ODBC Manager.
           The program needs to be compiled with an -Fxa and -Fo option 
           pointing to path for XFD creation.  The program needs a .cfg file
           to point to the file directory when creating or adding to the
           data file.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT work-file
              ASSIGN TO pet-file
              ORGANIZATION IS INDEXED
              ACCESS IS DYNAMIC
              RECORD KEY IS type-id
              FILE STATUS IS qa-file-status.

       DATA DIVISION.
       FILE SECTION.
      $XFD FILE=patients
       FD  work-file.
       01  pet-record.
           05  type-id.
		   10 atype             pic x.
		   10 ano			pic 99.
	     05  owner                pic x(30).
           05  breed                pic x(25).
           05  gender               pic x.
       WORKING-STORAGE SECTION.
       01  pet-file                 pic x(8). 
       01  qa-file-status           pic xx.

       PROCEDURE DIVISION.

       MAIN-LOGIC.

           move "file1" to pet-file.
           open output work-file.
           move "C" to atype.
           move 01 to ano.
           move "Ms Mary Johnson" to owner.
           move "Orange Tiger" to breed.
           move "M" to gender.
           write pet-record.
           move "C" to atype.
           move 02 to ano.
           move "Mrs Anna Bower" to owner.
           move "Silver Tabby" to breed.
           move "F" to gender.
           write pet-record.
           close work-file.

	     move "file2" to pet-file.
           open output work-file.
           move "D" to atype.
           move 03 to ano.
           move "Ms Ellen Rodriguez" to owner.
           move "Red Shiba Inu" to breed.
           move "M" to gender.
           write pet-record.
           move "D" to atype.
           move 04 to ano.
           move "Mr Jason Jefferson" to owner.
           move "Red Siberian Husky" to breed.
           move "M" to gender.
           write pet-record.
           close work-file.
   
	     move "file3" to pet-file.
           open output work-file.
           move "B" to atype.
	     move 05 to ano.
           move "Ms Mary Johnson" to owner.
           move "African Gray" to breed.
           move "M" to gender.
           write pet-record.
           move "B" to atype.
           move 06 to ano.
           move "Mr Bill Sanders" to owner.
           move "Blue Parakeet" to breed.
           move "M" to gender.
           write pet-record.
           close work-file.

           Exit Program.
           Stop Run.

