identification division.
program-id.	xmltostr.
|-----------------------------------------------------------------------------|
| Copyright (c) 1989-2014 by Micro Focus   			              | 
| User of ACUCOBOL-GT may freely use this file. 			      |
|-----------------------------------------------------------------------------|
|
|-----------------------------------------------------------------------------|
| This sample program illustrates a method of using the C$XML Library         |
| Routines to read an XML file and create an in-memory string with the        |
| contents of that file, using the CXML-WRITE-STRING opcode.                  |
|                                                                             |
| Compile with -Ca (to use ANSI display) and run with -b                      |
|-----------------------------------------------------------------------------|

data division.

working-storage section.

copy "def/acucobol.def".

77  arg-count                                   pic 99 comp-1.
77  xml-filename				pic x(60).
77  xml-handle					usage handle.
77  char-ptr					usage pointer.
77  ret-disp					pic z(8)9.
78  string-length				value 1000.
77  my-offset					pic 9(9).
77  my-length					pic 9(9).
77  move-amt					pic 9(4).
77  total-length				pic 9(9).
77  xml-string					pic x(string-length).

77  errors-storage				pic x(60).
77  errors-value				pic x(70) value spaces.

procedure division chaining xml-filename.
main-paragraph.
    call "C$NARG" using arg-count.
    if arg-count not = 1
        display "ERROR: You must specify an XML filename as an argument. Press RETURN"
        exit program
        stop run
    end-if.

    call "C$XML" using CXML-PARSE-FILE, xml-filename.
    if return-code not positive
        perform show-error
        exit program
        stop run
    end-if.
    move return-code to xml-handle.

    call "C$XML" using CXML-WRITE-STRING, xml-handle, xml-string.
    evaluate true
      when return-code = 0
        display xml-string

      when return-code > 0
        move return-code to ret-disp, total-length
	display "Allocating a larger string:", ret-disp
	call "M$ALLOC" using total-length char-ptr
	if char-ptr not = null
	    display "Got memory"
 	    call "C$XML" using CXML-WRITE-STRING, xml-handle, char-ptr
	    move 1 to my-offset
	    move string-length to move-amt
	    perform until my-offset >= total-length
	        compute my-length = my-offset + move-amt - 1
		if my-length greater than total-length
		    compute move-amt = total-length - my-offset + 1
		end-if
		move spaces to xml-string
	        call "M$GET" using char-ptr, xml-string, move-amt, my-offset
		display xml-string
		add move-amt to my-offset
	    end-perform
	    call "M$FREE" using char-ptr
	end-if

      when return-code < 0
        perform show-error
    end-evaluate.
    call "C$XML" using CXML-RELEASE-PARSER, xml-handle.
    exit program.
    stop run.
        
show-error.
    call "C$XML" using CXML-GET-LAST-ERROR errors-storage.

    move "Err No:"   to errors-value(1:).
    move return-code to errors-value(9:).
    move errors-storage to errors-value(20:).
    display errors-value.
