#!/bin/sh

# Assume we are in $ACUCOBOL/sample/alfred, as distributed
ACUCOBOL=../..
CCBL=${ACUCOBOL}/bin/ccbl
RUNCBL=${ACUCOBOL}/bin/runcbl
SAMPLE=${ACUCOBOL}/sample
COPYPATH=$SAMPLE:.:copylib:resource; export COPYPATH

# If you want to compile in debug, modify and/or uncomment the following line
# DEBUGFLAGS=-Gd

# To generate listings, modify and/or uncomment the following line
# LISTFLAGS=-Lof list/@.lst

# First generate alfred.mnu - the alfred menu

# Make sure genmenu can be executed
build_menu()
{
    echo Building genmenu.acu
    $CCBL -xv -Sp $SAMPLE $SAMPLE/genmenu.cbl
    echo Generating alfred.mnu from alfred.gmu
    $RUNCBL -b -1 genmenu alfred.gmu alfred.mnu
    rm -f genmenu.acu
}

# Now we can build all the alfred objects (alfred and ParseXFD)
build_objects()
{
#    build_menu
    echo Compiling ParseXFD.cbl
    $CCBL -xv $DEBUGFLAGS $LISTFLAGS -o object/@.acu source/ParseXFD.cbl
    echo Compiling alfred.cbl
    $CCBL -xv $DEBUGFLAGS $LISTFLAGS -o object/@.acu source/alfred.cbl
}

clean_objects()
{
    echo Cleaning object/\*.acu list/\*.lst *.adb
    rm -f object/*.acu list/*.lst *.adb
}

if [ "$1". = "clean". ]
then
    clean_objects
else
    build_objects
fi
