       program-id.  frame-styles.

      * Copyright (c) 1996-2014 by Micro Focus. Users of ACUCOBOL-GT
      * may freely modify and redistribute this program.

       remarks.
           This program demonstrates the various styles available for
           frames (group boxes).

       working-storage section.

       77  sample-title                        pic x(10).
       77  button-legend                       pic x(12).
       77  back-color                          pic 9(5).
       77  initialize-gray-button              pic 9 value 1.
       77  show-colors-flag                    pic 9 value zero.

       77  key-status
           is special-names crt status         pic 9(4) value zero.
           88  titles-button-pushed            value 1.
           88  gray-button-pushed              value 2.
           88  blue-button-pushed              value 3.
           88  green-button-pushed             value 4.
           88  cyan-button-pushed              value 5.
           88  red-button-pushed               value 6.
           88  magenta-button-pushed           value 7.
           88  brown-button-pushed             value 8.
           88  color-button-pushed             values 2 thru 8.
           88  ok-button-pushed                value 13.

       01  screen-control
           is special-names screen control.
           03  accept-control                  pic 9.
           03  control-value                   pic 999.

       copy "def/acucobol.def".

       screen section.
       01  screen-1.
           03  label "Normal", line 3.5, col 3, cline 5.
           03  label "Raised", line + 2, col 3, cline + 3.
           03  label "Lowered", line + 2, col 3, cline + 3.
           03  label "Engraved", line + 2, col 3, cline + 3.
           03  label "Rimmed", line + 2, col 3, cline + 3.

           03  label "Default", line 2, col 14, size 12, center.
           03  label "Heavy", line 2, col 29, size 12, center.
           03  label "Alternate" line 2, col 44, size 12, center.

           03  frames.
               05  frame, sample-title, line 3, col 14, lines 3,
                   cline 4.
               05  frame, sample-title, line + 2, col 14, lines 3,
                   cline + 3, raised.
               05  frame, sample-title, line + 2, col 14, lines 3,
                   cline + 3, lowered.
               05  frame, sample-title, line + 2, col 14, lines 3,
                   cline + 3, engraved.
               05  frame, sample-title, line + 2, col 14, lines 3,
                   cline + 3, rimmed.

               05  frame, sample-title, line 3, col 29, lines 3,
                   cline 4, heavy.
               05  frame, sample-title, line + 2, col 29, lines 3,
                   cline + 3, raised, heavy.
               05  frame, sample-title, line + 2, col 29, lines 3,
                   cline + 3, lowered, heavy.
               05  frame, sample-title, line + 2, col 29, lines 3,
                   cline + 3, engraved, heavy.
               05  frame, sample-title, line + 2, col 29, lines 3,
                   cline + 3, rimmed, heavy.

               05  frame, sample-title, line 3, col 44, lines 3,
                   cline 4, alternate, very-heavy.
               05  frame, sample-title, line + 2, col 44, lines 3,
                   cline + 3, alternate raised, very-heavy.
               05  frame, sample-title, line + 2, col 44, lines 3,
                   cline + 3, alternate lowered, heavy.
               05  frame, sample-title, line + 2, col 44, lines 3,
                   cline + 3, alternate engraved, very-heavy.
               05  frame, sample-title, line + 2, col 44, lines 3,
                   cline + 3, alternate rimmed, very-heavy.

           03  push-button, line 3, col 61, size 11, cline 4, ok-button,
               title "E&xit".
           03  push-button, line + 1.25, col 61, size 11, cline + 2,
               title button-legend, termination-value = 1.

           03  frame, lowered, line + 1.5, col 61, lines 12, size 12,
               cline + 2, clines 8, visible = show-colors-flag.

      * The radio buttons for the colors have the "notify" style so that
      * the program gains control as soon as they are pressed.  The
      * actual handling of the color change is performed by
      * color-button-procedure.  This is done as an AFTER procedure so that
      * we can easily keep our place in the Screen Section if the user is
      * using the arrow keys to visit each color button.  We could track
      * this in the main program if we wanted, but it is easier to let
      * the runtime do it for us.

           03  radio-button, "&Gray", line + 0.75, cline + 1, col 62,
               value initialize-gray-button,
               notify, termination-value = 2
               visible = show-colors-flag
               after procedure is color-button-procedure.
           03  radio-button, "&Blue", line + 1, col 62,
               notify, termination-value = 3
               visible = show-colors-flag
               after procedure is color-button-procedure.
           03  radio-button, "Gr&een", line + 1, col 62,
               notify, termination-value = 4
               visible = show-colors-flag
               after procedure is color-button-procedure.
           03  radio-button, "&Cyan", line + 1, col 62,
               notify, termination-value = 5
               visible = show-colors-flag
               after procedure is color-button-procedure.
           03  radio-button, "&Red", line + 1, col 62,
               notify, termination-value = 6
               visible = show-colors-flag
               after procedure is color-button-procedure.
           03  radio-button, "&Magenta", line + 1, col 62,
               notify, termination-value = 7
               visible = show-colors-flag
               after procedure is color-button-procedure.
           03  radio-button, "Bro&wn", line + 1, col 62,
               notify, termination-value = 8
               visible = show-colors-flag
               after procedure is color-button-procedure.


       procedure division.
       main-logic.
           accept terminal-abilities from terminal-info.
           if has-color
               move 1 to show-colors-flag.

           display standard window,
               title "Frame Styles - frames.cbl",
               lines 15, size 75,
               cell size = entry-field font,
               background-low.

           perform until ok-button-pushed
               if sample-title = spaces
                   move "&Titles On" to button-legend
               else
                   move "&Titles Off" to button-legend
               end-if
               display screen-1
               accept screen-1
               evaluate true
                 when titles-button-pushed
                   if sample-title = spaces
                       move "Title" to sample-title
                   else
                       move spaces to sample-title
                   end-if
               end-evaluate
           end-perform.
           stop run.

       color-button-procedure.
           if color-button-pushed
               evaluate true
                 when gray-button-pushed
                   move bckgrnd-white to back-color
                 when blue-button-pushed
                   move bckgrnd-blue to back-color
                 when green-button-pushed
                   move bckgrnd-green to back-color
                 when cyan-button-pushed
                   move bckgrnd-cyan to back-color
                 when red-button-pushed
                   move bckgrnd-red to back-color
                 when magenta-button-pushed
                   move bckgrnd-magenta to back-color
                 when brown-button-pushed
                   move bckgrnd-brown to back-color
               end-evaluate
               perform use-new-color
      * Force ACCEPT statement to continue from current location.
               move 1 to accept-control
           end-if.

       use-new-color.
      * Establish a new background color for the frames.  First
      * we remove the old frames and then fill in a subwindow
      * with the new color.
           destroy frames
           if has-graphical-interface then
               display subwindow, erase,
                   line 3, column 13,
                   lines 10, size 44,
                   color black + back-color
           else
               display subwindow, erase,
                   line 4, column 13,
                   lines 15, size 44,
                   color black + back-color
           end-if

      * Now re-establish a full-size subwindow (because the frame
      * coordinates are relative to the current subwindow).  Note
      * that this full-size subwindow inherits the new background color.
           display subwindow

      * Display the new frames.  They use the current background color.
           display frames
