identification division.
program-id.  CobolCallingJava.
data division.
working-storage section.
       COPY "../def/java.def".

01 LOGMSG 		PIC X(256).
01 STATUS-VAL 		PIC S9(02) VALUE ZERO.
01 FIELD-INT		USAGE IS SIGNED-INT.			
01 FIELD-RET		USAGE IS SIGNED-INT.			
01 FIELD-DOUBLE		USAGE IS DOUBLE.			
01 FIELD-DOUBLERET	USAGE IS DOUBLE.			
01 FIELD-STRING		PIC X(80).			
01 FIELD-STRINGRET	PIC X(256).			
01 OBJECT-HANDLE	USAGE HANDLE.			
01 ARRAY-HANDLE		USAGE HANDLE.			
01 ARRAY-SIZE		USAGE IS SIGNED-INT VALUE 3.			
01 OBJ-HANDLE-ARR	USAGE HANDLE occurs 3.			
01 STRING-TABLE		PIC X(20) occurs 3.			
01 INT-TABLE		USAGE IS SIGNED-INT occurs 3.
01 INT-GROUP.
    03  INT-DATA occurs 3 times.
        05  INT-ELEMENT signed-int.


linkage section.
77  string-in-out	pic x(256) value spaces.
77  int-in-out		USAGE IS SIGNED-INT.			
77  double-in-out	USAGE IS DOUBLE.			

procedure division using string-in-out, int-in-out, double-in-out.
main-logic.

*          .CallJavaMainTest.
      
	   DISPLAY "******************************************" UPON SYSERR.
	   DISPLAY "** Call Java Main Test *******************" UPON SYSERR.
	   DISPLAY "******************************************" UPON SYSERR.
	   
	   CALL "C$JAVA" USING CJAVA-CALLJAVAMAIN, "CobolCallingJava", "String1", "String2",
	        "String3" GIVING STATUS-VAL.
	   
*          .ArrayTest.
      
	   DISPLAY "******************************************" UPON SYSERR.
	   DISPLAY "** Array Test ****************************" UPON SYSERR.
	   DISPLAY "******************************************" UPON SYSERR.
	   
*          .IntArrayTest.
	   DISPLAY "Int Array Test" UPON SYSERR.
	   CALL "C$JAVA" USING CJAVA-NEW, "CobolCallingJava", "()V" GIVING OBJECT-HANDLE.
	   CALL "C$JAVA" USING CJAVA-CREATEARRAY, CJAVA-INTARRAY, ARRAY-SIZE GIVING ARRAY-HANDLE.
	   MOVE 1111 to INT-TABLE(1)
	   MOVE 2222 to INT-TABLE(2)
	   MOVE 3333 to INT-TABLE(3)
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 1, INT-TABLE(1), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 2, INT-TABLE(2), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 3, INT-TABLE(3), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 3, INT-TABLE(1), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 2, INT-TABLE(2), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 1, INT-TABLE(3), GIVING STATUS-VAL.
	   MOVE 0000 to INT-TABLE(1)
	   MOVE 0000 to INT-TABLE(2)
	   MOVE 0000 to INT-TABLE(3)
	   CALL "C$JAVA" USING CJAVA-CONVERTARRAYTOTABLE, ARRAY_HANDLE, 3, 0, INT-TABLE(1) GIVING STATUS-VAL.
	   MOVE 9999 to INT-TABLE(1)
	   MOVE 9999 to INT-TABLE(2)
	   MOVE 9999 to INT-TABLE(3)
	   MOVE 1111 to INT-ELEMENT(1)
	   MOVE 2222 to INT-ELEMENT(2)
	   MOVE 3333 to INT-ELEMENT(3)
	   CALL "C$JAVA" USING CJAVA-CONVERTTABLETOARRAY, INT-TABLE(1), 3, 0, ARRAY-HANDLE, GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava",
	   	"CobolCallingJavaIntArray", "([I)I", INT-GROUP, FIELD-RET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava",
	   	"CobolCallingJavaIntArray", "([I)I", ARRAY-HANDLE, FIELD-RET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-CLEARARRAY, ARRAY-HANDLE GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava",
	   	"CobolCallingJavaIntArray", "([I)I", ARRAY-HANDLE, FIELD-RET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-DELETE, OBJECT-HANDLE GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-DELETE, ARRAY-HANDLE GIVING STATUS-VAL.
	   DISPLAY "End IntArrayTest" UPON SYSERR.
	   
*          .StringArrayTest.
	   DISPLAY "String Array Test" UPON SYSERR.
	   CALL "C$JAVA" USING CJAVA-NEW, "CobolCallingJava", "()V" GIVING OBJECT-HANDLE.
	   CALL "C$JAVA" USING CJAVA-CREATEARRAY, CJAVA-STRINGARRAY, 3 GIVING ARRAY-HANDLE.
	   MOVE "00000000000000000000" TO STRING-TABLE(1)
	   MOVE "11111111111111111111" TO STRING-TABLE(2)
	   MOVE "22222222222222222222" TO STRING-TABLE(3)
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 1, STRING-TABLE(3), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 2, STRING-TABLE(2), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 3, STRING-TABLE(1), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, 
	   	"CobolCallingJava", "CobolCallingJavaStringArray", "([Ljava/lang/String;)X",
	   	ARRAY-HANDLE, FIELD-STRINGRET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 1, STRING-TABLE(1), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 2, STRING-TABLE(2), GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 3, STRING-TABLE(3), GIVING STATUS-VAL.
	   MOVE "AAAAAAAAAAAAAAAAAAAA" TO STRING-TABLE(1)
	   MOVE "AAAAAAAAAAAAAAAAAAAA" TO STRING-TABLE(2)
	   MOVE "AAAAAAAAAAAAAAAAAAAA" TO STRING-TABLE(3)
	   CALL "C$JAVA" USING CJAVA-CONVERTTABLETOARRAY, STRING-TABLE(1), 3, 20, ARRAY-HANDLE, GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, 
	   	"CobolCallingJava", "CobolCallingJavaStringArrayModify", "([Ljava/lang/String;)X",
	   	ARRAY-HANDLE, FIELD-STRINGRET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-CONVERTARRAYTOTABLE, ARRAY_HANDLE, 3, 20, STRING-TABLE(1) GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, 
	   	"CobolCallingJava", "CobolCallingJavaStringArray", "([Ljava/lang/String;)X",
	   	ARRAY-HANDLE, FIELD-STRINGRET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-DELETE, OBJECT-HANDLE GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-DELETE, ARRAY-HANDLE GIVING STATUS-VAL.
	   DISPLAY "End StringArrayTest" UPON SYSERR.
	   
*          .DoubleArrayTest.
	   DISPLAY "Double Array Test" UPON SYSERR.
	   CALL "C$JAVA" USING CJAVA-NEW, "CobolCallingJava", "()V" GIVING OBJECT-HANDLE.
	   CALL "C$JAVA" USING CJAVA-CREATEARRAY, CJAVA-DOUBLEARRAY, ARRAY-SIZE GIVING ARRAY-HANDLE.
	   MOVE 111.111 to FIELD-DOUBLE.
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 1, FIELD-DOUBLE, GIVING STATUS-VAL.
	   MOVE 222.222 to FIELD-DOUBLE.
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 2, FIELD-DOUBLE, GIVING STATUS-VAL.
	   MOVE 333.333 to FIELD-DOUBLE.
	   CALL "C$JAVA" USING CJAVA-SETARRAYELEMENT, ARRAY-HANDLE, 3, FIELD-DOUBLE, GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 1, FIELD-DOUBLERET, GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 2, FIELD-DOUBLERET, GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-GETARRAYELEMENT, ARRAY-HANDLE, 3, FIELD-DOUBLERET, GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava", "CobolCallingJavaDoubleArray", "([D)D",
	   	ARRAY-HANDLE, FIELD-DOUBLERET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava", "CobolCallingJavaDoubleArray", "([D)D",
	   	ARRAY-HANDLE, FIELD-DOUBLERET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-CLEARARRAY, ARRAY-HANDLE GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava", "CobolCallingJavaDoubleArray", "([D)D",
	   	ARRAY-HANDLE, FIELD-DOUBLERET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-DELETE, OBJECT-HANDLE GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-DELETE, ARRAY-HANDLE GIVING STATUS-VAL.
	   DISPLAY "End DoubleArrayTest" UPON SYSERR.

	   
	   DISPLAY "******************************************" UPON SYSERR.
	   DISPLAY "** Virtural Call *************************" UPON SYSERR.
	   DISPLAY "******************************************" UPON SYSERR.
	   
*          .TestStringV.
	   DISPLAY "test stringV" UPON SYSERR.
	   move "string start one" to FIELD-STRING
	   move "string start two" to FIELD-STRINGRET
	   DISPLAY FIELD-STRING.
	   DISPLAY FIELD-STRINGRET.
	   CALL "C$JAVA" USING CJAVA-NEW, "CobolCallingJava", "(X)V", FIELD-STRING GIVING OBJECT-HANDLE.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava", "CobolCallingJavaStringV", "(X)X",
	   	FIELD-STRING, FIELD-STRINGRET GIVING STATUS-VAL.
	   CALL "C$JAVA" USING CJAVA-DELETE, OBJECT-HANDLE GIVING STATUS-VAL.
	   DISPLAY "CobolCallingJavaStringV (X)X" UPON SYSERR.
	   
*          .TestIntV.
	   DISPLAY "test integerV" UPON SYSERR.
	   move 24 to FIELD-INT.
	   move 25 to FIELD-RET.
	   CALL "C$JAVA"
	   	USING CJAVA-NEW, "CobolCallingJava", "(I)V", FIELD-INT GIVING OBJECT-HANDLE.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava", "CobolCallingJavaIntV", "(I)I",
	   	FIELD-INT, FIELD-RET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-DELETE, OBJECT-HANDLE GIVING STATUS-VAL.
	   DISPLAY "CobolCallingJavaIntV (I)I" UPON SYSERR.
	   
*          .TestDoubleV.
	   DISPLAY "test doubleV" UPON SYSERR.
	   move 1.555 to FIELD-DOUBLE
	   move 1.666 to FIELD-DOUBLERET
	   CALL "C$JAVA" USING CJAVA-NEW, "CobolCallingJava", "(D)V", FIELD-DOUBLERET GIVING OBJECT-HANDLE.
	   CALL "C$JAVA" USING CJAVA-CALL, OBJECT-HANDLE, "CobolCallingJava", "CobolCallingJavaDoubleV", "(D)D",
	   	FIELD-DOUBLE, FIELD-DOUBLERET GIVING STATUS-VAL
	   CALL "C$JAVA" USING CJAVA-DELETE, OBJECT-HANDLE GIVING STATUS-VAL.
	   DISPLAY "CobolCallingJavaDoubleV (D)D" UPON SYSERR.
	   
	   
	   DISPLAY "******************************************" UPON SYSERR.
	   DISPLAY "** Static Call ***************************" UPON SYSERR.
	   DISPLAY "******************************************" UPON SYSERR.
	   
*          .TestStringStatic.
	   DISPLAY "TestStringStatic" UPON SYSERR.
	   move "string start one" to FIELD-STRING
	   move "string start two" to FIELD-STRINGRET
	   STRING FIELD-STRING INTO LOGMSG END-STRING
	   DISPLAY LOGMSG.
	   STRING FIELD-STRINGRET INTO LOGMSG END-STRING
	   DISPLAY LOGMSG.
	   CALL "C$JAVA" USING CJAVA-CALLSTATIC, "CobolCallingJava", "CobolCallingJavaString", "(Ljava/lang/String;)Ljava/lang/String;",
	   	FIELD-STRING, FIELD-STRINGRET GIVING STATUS-VAL
	   DISPLAY "CallStatic CobolCallingJavaString (X)X" UPON SYSERR.
	   
*          .TestIntStatic.
	   DISPLAY "TestIntStatic" UPON SYSERR.
	   move 24 to FIELD-INT.
	   move 25 to FIELD-RET.
	   CALL "C$JAVA" USING CJAVA-CALLSTATIC, "CobolCallingJava", "CobolCallingJavaInt", "(I)I", FIELD-INT, FIELD-RET
	   	GIVING STATUS-VAL
	   DISPLAY "CallStatic CobolCallingJavaInt (I)I" UPON SYSERR.
	   
*          .TestDoubleStatic.
	   DISPLAY "TestDoubleStatic" UPON SYSERR.
	   move 1.555 to FIELD-DOUBLE
	   move 1.666 to FIELD-DOUBLERET
	   CALL "C$JAVA" USING CJAVA-CALLSTATIC, "CobolCallingJava", "CobolCallingJavaDouble", "(D)D",
	   	FIELD-DOUBLE, FIELD-DOUBLERET GIVING STATUS-VAL
	   DISPLAY "CallStatic CobolCallingJavaDouble (D)D" UPON SYSERR.
	   
