       identification division.
       program-id.  LABEL_STYLE.
       date-written.  11-May-95

      * Copyright (c) 1996-2014 by Micro Focus. Users of ACUCOBOL-GT
      * may freely modify and redistribute this program.

       remarks.
           This program tests the LABEL STYLE control type of ACUCOBOL-GT
           for Windows, version 3.0.  Labels are display only and
           can not any input from the user.

      *************************************************
       data division.
       working-storage section.

       copy "def/acucobol.def".
       copy "def/acugui.def".

       77  small-font                          HANDLE.

       77  intro-text                          pic x(400) value
           "This program and source code illustrates the ACUCOBOL-GT, ve
      -    "r. 3.0, LABEL specific styles: LEFT, CENTER, RIGHT, and the 
      -    "default.  Use this program and code as a primer on label tex
      -    "t alignment within a region.".

       77  key-status
                is SPECIAL-NAMES  CRT STATUS    pic 9(4).
                88  exit-button-pushed          value 13.

       77  window-lines                         pic 99.

      *************************************************
       screen section.
       01  screen-1.
           03  label "Default"
               line 2, column 3, size 16 cells.

           03  label, "LEFT", LEFT,
               line 2, column + 4, size 16 cells.

           03  label, "CENTER", CENTER,
               line 2, column + 4, size 16 cells.

           03  label, "RIGHT", RIGHT,
               line 2, column + 4, size 16 cells.

           03  label, title intro-text,
               font small-font,
               color bckgrnd-red,
               line 4, column 2, size 18 cells, lines 10,
               clines 14.

           03  label, title intro-text, LEFT,
               font small-font,
               color bckgrnd-green,
               line 4, column + 2, size 18 cells, lines 10,
               clines 14.

           03  label, intro-text, CENTER,
               font small-font,
               color bckgrnd-red,
               line 4, column + 2, size 18 cells, lines 10,
               clines 14.

           03  label, title intro-text, RIGHT,
               font small-font,
               color bckgrnd-green,
               line 4, column + 2, size 18 cells, lines 10,
               clines 14.

           03  push-button, "Exit Program",
               ok-button,
               line 16, column 31, size 18,
               cline 20.

      *************************************************
       procedure division.
       main-logic.

      *    Figure out what kind of display we have access to.
           accept terminal-abilities from terminal-info.
           if has-graphical-interface then
               move 18 to window-lines
           else
               move 22 to window-lines
           end-if.

      *    Setup a gray screen background

           display standard window,
               title "Label Style Sample - label.cbl"
               lines window-lines, size 77,
               background-low.

      *    Grab the small fonts
           accept small-font from standard object "small-font".

           display screen-1.

           perform, with test after, until exit-button-pushed
                accept screen-1
           end-perform.

           stop run.
