       identification division.
       program-id.  Push_Button.
       date-written.  8-July-95

      * Copyright (c) 1996-2014 by Micro Focus. Users of ACUCOBOL-GT
      * may freely modify and redistribute this program.

       remarks.
           This program illustrates the PUSH BUTTON control type.

      **************************************************
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       copy "def/acucobol.def".
       copy "def/acugui.def".
       copy resource "bmpbtn.bmp".

       77  large-font                  USAGE   HANDLE.
       77  BITMAP-BUTTON               pic s9(9) comp-4.

       77  ok-text             pic x(100) value
           "Default style push button with a return code set to '1'.".
       77  bitmap-text1        pic x(100) value
           "Icon style push button with a return code set to '2'.".
       77  bitmap-text2        pic x(200) value
           "This push button consists of one bitmap.  The runtime manage
      -    "s the pressed down, and elevated look.".

       77  current-return-cd   pic x(1) value "0".
       77  one-text            pic x(1) value "1".
       77  two-text            pic x(1) value "2".

       77  key-status
                is SPECIAL-NAMES  CRT STATUS    pic 9(4) value 0.
                88  exit-button-pushed          value 13.

       78  OK-btn1-pressed                      value 707.
       78  OK-BMP-btn2-pressed                  value 777.

      **************************************************
       screen section.
       01  screen-1.
           03  push-button, "Exit",
               ok-button, FONT LARGE-FONT,
               line 21, column 18, size 11.

           03  push-button, "OK",
               column 5, line 3,
               FONT LARGE-FONT,
               termination-value = OK-btn1-pressed.

           03  label, ok-text, line 3, column 18, LINES 2, SIZE 23.

           03  push-button,
               column 5, line 7,
               Lines 40, size 65,
               BITMAP, BITMAP-NUMBER = 1,
               termination-value = OK-BMP-btn2-pressed.

           03  label, bitmap-text1,
               line 7, column 18,
               LINES 2, SIZE 23.

           03  label, bitmap-text2,
               line 10, column 18,
               LINES 5, SIZE 23.

           03  label, "Current return code = ",
               column 5, line 16.

           03  frame, line 15.5, column 23, LINES 2.5, SIZE 5.5.

           03  label, current-return-cd, line 16, column 25.

       01  screen-2.
           03  push-button, "Exit",
               ok-button, FONT LARGE-FONT,
               line 21, column 18, size 11.

           03  push-button, "OK",
               column 5, line 3,
               FONT LARGE-FONT,
               termination-value = OK-btn1-pressed.

           03  label, ok-text, line 3, column 18, LINES 2, SIZE 23,
               csize 31.

           03  push-button, "BMP"
               column 5, line 7,
               FONT LARGE-FONT,
               termination-value = OK-BMP-btn2-pressed.

           03  label, bitmap-text1,
               line 7, column 18,
               LINES 2, SIZE 23,
               csize 29.

           03  label, bitmap-text2,
               line 10, column 18,
               LINES 5, SIZE 23,
               csize 25.

           03  label, "Current return code = ",
               column 5, line 16.

           03  frame, line 15.5, column 25, LINES 2.5, SIZE 5.5,
               ccol 27, csize 5.

           03  label, current-return-cd, line 16, column 27,
               ccol 29.

      **************************************************
       procedure division.
       main-logic.
      *    Setup a gray screen background
           display standard window,
               title "Push Button Sample - pushbtn.cbl"
               lines 24, size 45,
               background-low.


      *    Grab the large fonts
           accept large-font from standard object "large-font".

      *    Note that if we fail to load the bitmap, we just silently
      *    move on without the bitmap.

           call "w$bitmap" using wbitmap-load,
                           "bmpbtn.bmp",
                           giving bitmap-button.

           perform, with test after, until exit-button-pushed
                evaluate key-status
                  when OK-btn1-pressed
                    move one-text to current-return-cd
                  when OK-BMP-btn2-pressed
                    move two-text to current-return-cd
                end-evaluate
                if bitmap-button = 0
                    display screen-2
                    accept screen-2
                else
                    display screen-1
                    accept screen-1
                end-if
           end-perform.
           stop run.
