identification division.
program-id.    regexp.
$set DISPLAY(CONSOLE)
|-----------------------------------------------------------------------------|
| Copyright (c) 1989-2014 by Micro Focus.                                     |
| Users of ACUCOBOL-GT may freely use this file.                              |
|-----------------------------------------------------------------------------|
|
|-----------------------------------------------------------------------------|
| This sample program illustrates the use of C$REGEXP to scan strings for     |
| patterns.  This is a very simple example, but does show all the uses of     |
| the new library routine.                                                    |
|-----------------------------------------------------------------------------|
environment division.
input-output section.
file-control.
    select search-file
    assign to input search-filename
    organization is line sequential
    file status is search-status.

data division.
file section.
*  The size of the record area of this file determines tha maximum
*  line length of the file we are searching.
fd  search-file.
01  search-record                   pic x(79).

working-storage section.
copy "def/acucobol.def".

01  opcode                          pic 99.
01  CommandLine                     pic x(256).
01  search-status                   pic xx.
01  regular-expression-data.
    05  search-filename             pic x(80).
    05  regular-expression          pic x(80).
    05  filler                      pic x comp-x value 0.
    05  regexp-handle               pointer.
    05  match-handle                pointer.
    05  numgroups                   pic 999.
    05  idx                         pic 999.
    05  match-start                 pic 999.
    05  match-end                   pic 999.
    05  group-start                 pic 999.
    05  group-end                   pic 999.

01  passed-regexp                   pic x(80).
01  passed-filename                 pic x(80).

procedure division chaining passed-regexp, passed-filename..
main-paragraph.
    if passed-regexp = spaces or
       passed-filename = spaces
        display "Usage: regexp regular-expression, filename"
        stop run
    end-if.
    move AREGEXP-GET-LEVEL to opcode.
    call "C$REGEXP" using opcode.
    if return-code = AREGEXP-NONE
        display "This runtime doesn't support regular expressions"
        stop run
    end-if.

    display "Filename: " passed-filename.
    display "Regular expression: " passed-regexp.
    move passed-filename to search-filename.
*  The next statement will cause the COBOL program to abort if
*  the entered filename does not exist or has some other problem.
    open input search-file.
    move passed-regexp to regular-expression.
*  For this sample, trailing spaces aren't allowed.
    inspect regular-expression replacing trailing spaces by low-values.
    move AREGEXP-COMPILE to opcode.
    call "C$REGEXP" using opcode, regular-expression.
    move return-code to regexp-handle.
    if regexp-handle = null
        perform regexp-error
    end-if.
    perform until search-status = "10"
        read search-file next
          at end
            continue
          not at end
            move 0 to match-start
            move AREGEXP-MATCH to opcode
            call "C$REGEXP" using opcode, regexp-handle,
                    search-record, 0, match-start, match-end
            move return-code to match-handle
            if match-handle not = null
                display search-record
                move AREGEXP-NUMGROUPS to opcode
                call "C$REGEXP" using opcode, match-handle
                if return-code not = 0
                    move return-code to numgroups
                    perform show-groups
                end-if
                perform until match-handle = 0
                    move AREGEXP-RELEASE-MATCH to opcode
                    call "C$REGEXP" using opcode, match-handle
                    display "Start: " match-start
                            " End: " match-end " "
                            search-record(match-start:match-end - match-start)
                    move match-end to match-start
                    move 0 to match-end
                    if match-start < 80
                        move AREGEXP-MATCH to opcode
                        call "C$REGEXP" using opcode, regexp-handle,
                                search-record, 0,
                                match-start, match-end
                        move return-code to match-handle
                    else
                        set match-handle to null
                    end-if
                end-perform
            end-if
        end-read
    end-perform.

*  Clean up the resources we've used.
    move AREGEXP-RELEASE to opcode.
    call "C$REGEXP" using opcode, regexp-handle.
    close search-file.
    display "Done".
    stop run.

show-groups.
    display numgroups " groups".
    move AREGEXP-GETMATCH to opcode.
    perform varying idx from 0 by 1 until idx >= numgroups
        call "C$REGEXP" using opcode, match-handle, idx,
             group-start, group-end
        display "Group " idx ": " search-record(group-start:group-end - group-start)
    end-perform.

regexp-error.
    move AREGEXP-LAST-ERROR to opcode.
    call "C$REGEXP" using opcode.
    move return-code to idx.
    display "Error: " idx.
    close search-file.
    stop run.
