       IDENTIFICATION DIVISION.
       PROGRAM-ID.    SOCKHTML.

      * Copyright (c) 1989-2014 by Micro Focus
      * Users of ACUCOBOL-GT may freely use this file.

       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT HTML-FILE
           ASSIGN TO DISK "webpage.html"
           BINARY SEQUENTIAL
           STATUS IS HTML-STATUS.

       DATA DIVISION.
       FILE SECTION.
       FD  HTML-FILE.
       78  DATA-LENGTH                        VALUE 1000.
       01  HTML-RECORD                        PIC X(DATA-LENGTH).

       WORKING-STORAGE SECTION.
       COPY "def/socket.def".

       77  HTML-STATUS                        PIC XX.
       77  SOCKET-HANDLE                      USAGE HANDLE.
       77  SERVER-NAME                        PIC X(40).
       77  AVAILABLE-AMOUNT                   PIC 9(9).
       77  GET-REQUEST                        PIC X(10).
       77  MINUS-ONE                          SIGNED-SHORT VALUE -1.
       77  HTML-RECORD-USED                   PIC 9(9) VALUE 1.
       77  AMOUNT-TO-READ                     PIC 9(9).

       PROCEDURE DIVISION.
       MAIN-PGH.
           DISPLAY WINDOW ERASE.
           DISPLAY "Connect to server: " LINE 5 COL 5.
           ACCEPT SERVER-NAME.
           INSPECT SERVER-NAME REPLACING TRAILING SPACES BY LOW-VALUES.
           CALL "C$SOCKET" USING AGS-CREATE-CLIENT, 80, SERVER-NAME
                           GIVING SOCKET-HANDLE.
           DISPLAY SOCKET-HANDLE CONVERT.
           IF SOCKET-HANDLE = NULL
               DISPLAY "Unable to connect to server" LINE 6 COL 5
               ACCEPT OMITTED
               STOP RUN
           END-IF.

           OPEN OUTPUT HTML-FILE.

           MOVE "GET" TO GET-REQUEST.
           MOVE X"0A0A" TO GET-REQUEST(4:2).
           CALL "C$SOCKET" USING AGS-WRITE, SOCKET-HANDLE,
                           GET-REQUEST, 5.
           PERFORM UNTIL 1 = 0
      *  We read a single byte to fill the internal socket buffer
      *  with data, and then we can query how much data is available.
               CALL "C$SOCKET" USING AGS-READ, SOCKET-HANDLE
                                     GET-REQUEST, MINUS-ONE
      *  Is the socket closed?
               IF RETURN-CODE = -1
                   EXIT PERFORM
               END-IF
      *  How much data is there to read?
               CALL "C$SOCKET" USING AGS-READ, SOCKET-HANDLE, 0, 0
               MOVE RETURN-CODE TO AVAILABLE-AMOUNT
               COMPUTE AMOUNT-TO-READ =
                    DATA-LENGTH - HTML-RECORD-USED + 1
      *  Note we are not reading lines, we are just reading blocks
               PERFORM UNTIL AVAILABLE-AMOUNT < AMOUNT-TO-READ
                   CALL "C$SOCKET" USING AGS-READ, SOCKET-HANDLE,
                                   HTML-RECORD(HTML-RECORD-USED:),
                                   AMOUNT-TO-READ
      *  We should really check for errors here: If return-code
      *  is not = data-length, then an error occured.
                   IF RETURN-CODE = -1
                       EXIT PERFORM
                   END-IF
                   WRITE HTML-RECORD
                   SUBTRACT RETURN-CODE FROM AVAILABLE-AMOUNT
                   MOVE 1 TO HTML-RECORD-USED
                   MOVE DATA-LENGTH TO AMOUNT-TO-READ
               END-PERFORM
               IF AVAILABLE-AMOUNT < AMOUNT-TO-READ
                   MOVE AVAILABLE-AMOUNT TO AMOUNT-TO-READ
               END-IF
               CALL "C$SOCKET" USING AGS-READ, SOCKET-HANDLE,
                               HTML-RECORD(HTML-RECORD-USED:),
                               AMOUNT-TO-READ
               ADD RETURN-CODE TO HTML-RECORD-USED
               IF HTML-RECORD-USED > DATA-LENGTH
                   WRITE HTML-RECORD
                   MOVE 1 TO HTML-RECORD-USED
               END-IF
           END-PERFORM.
           CALL "C$SOCKET" USING AGS-CLOSE, SOCKET-HANDLE.
           IF HTML-RECORD-USED > 1
               MOVE SPACES TO HTML-RECORD(HTML-RECORD-USED:)
               WRITE HTML-RECORD
           END-IF.
           CLOSE HTML-FILE.
           DISPLAY "Done - press <RETURN>" LINE 7 COL 5.
           ACCEPT OMITTED.
           STOP RUN.
