       Identification Division.
       Program-Id.  Example-2.
      *
      * Title: EXAMPLE2.CBL: Export / Import with XSLT stylesheets.
      *
      * Copyright (c) 2008-2014, Micro Focus (IP) Ltd.
      *
      * Version Identification:
      *   $Revision: 64691 $
      *   $Date: 2013-11-05 19:06:03 +0000 (Tue, 05 Nov 2013) $
      *   $URL: svn://sd-dev/acu/tags/v9-2-3-build-0-rc-1/cobolgt/sample/xmlext/example2.cbl $
      *
       Data Division.
       Working-Storage Section.

       Copy "s-struct.cpy".

       01  Done Pic X.
       01  WS-TimeStamp.
           02 WS-Date       PIC 9999/99/99.
           02 Filler        PIC XX Value Spaces.
           02 WS-Time       PIC 99/99/99/99.

       Copy "lixmlall.cpy".

       Procedure Division.
       A.
           Display "Example-2 - Illustrate EXPORT FILE & IMPORT FILE"
                   " with XSLT stylesheets".

           XML INITIALIZE.
           If Not XML-OK Go to Z End-If.

           Accept WS-Date From Date YYYYMMDD.
           Accept WS-Time From Time.
           Inspect WS-Time Converting "/" To ":".
           Move "." To WS-Time(9: 1).
           Move WS-TimeStamp To Time-Stamp.

      * Export from Address-Struct data converting data items
      *   from elements to attributes with toext.xsl.

           XML EXPORT FILE
               Address-Struct  *> reference to export source data item (input)
               "address2"      *> output document file name (input)
               Struct-Name     *> model data name string (input)
               "toext".        *> XSLT stylesheet file name (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address2.xml exported by XML EXPORT FILE".
           Perform Display-Address-Struct.
           Initialize Address-Struct.

      * Import into Address-Struct converting attributes
      *   to elements with toint.xsl.

           XML IMPORT FILE
               Address-Struct  *> reference to import target data item (input)
               "address2"      *> input document file name (input)
               Struct-Name     *> model data name string (input)
               "toint".        *> XSLT stylesheet file name (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address2.xml imported by XML IMPORT FILE".
           Perform Display-Address-Struct.

           Display Space.
           Display "You may inspect 'address2.xml'".
           Display Space.
           Go to Z.

       Display-Address-Struct.
           Display Space.
           Display "Name:        " Name.
           Display "Address-1:   " Address-1.
           Display "Address-2:   " Address-2.
           Display "Address-3:   " Address-3.
           Display "Country:     " Country.
           Display "Time-Stamp:  " Time-Stamp.

       Z.
           Copy "lixmltrm.cpy".

           Display "Press a key to terminate:".                         TESTS
           Accept Done.                                                 TESTS
           Stop Run.

           Copy "lixmldsp.cpy".

       End Program  Example-2.
