       Identification Division.
       Program-Id.  Example-8.
      *
      * Title: EXAMPLE8.CBL: Export / Well-Formed test / Validate.
      *
      * Copyright (c) 2008-2014, Micro Focus (IP) Ltd.
      *
      * Version Identification:
      *   $Revision: 64691 $
      *   $Date: 2013-11-05 19:06:03 +0000 (Tue, 05 Nov 2013) $
      *
       Data Division.
       Working-Storage Section.

       Copy "s-struct.cpy".

       01  Document-Pointer Usage Pointer.
       01  Document-Length  PIC 9(5) BINARY.
       01  Done Pic X.
       01  WS-TimeStamp.
           02 WS-Date       PIC 9999/99/99.
           02 Filler        PIC XX Value Spaces.
           02 WS-Time       PIC 99/99/99/99.

       Copy "lixmlall.cpy".

       Procedure Division.
       A.
           Display "Example-8 - Illustrate TEST-WELLFORMED TEXT"
                   " & VALIDATE TEXT".

           XML INITIALIZE.
           If Not XML-OK Go to Z End-If.

           Accept WS-Date From Date YYYYMMDD.
           Accept WS-Time From Time.
           Inspect WS-Time Converting "/" To ":".
           Move "." To WS-Time(9: 1).
           Move WS-TimeStamp To Time-Stamp.

           XML EXPORT TEXT
               Address-Struct     *> reference to export source data item (input)
               Document-Pointer   *> output document file name (input)
               Document-Length    *> model data name string (input)
               Struct-Name.
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document exported by XML EXPORT TEXT".
           Perform Display-Address-Struct.

           XML TEST WELLFORMED-TEXT
               Document-Pointer   *> document pointer data item (input)
               Document-Length.   *> length of document text to test (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document checked by XML TEST WELLFORMED-TEXT".

           XML VALIDATE TEXT
               Document-Pointer   *> document pointer data item (input)
               Document-Length    *> length of document text to validate (input)
               "example8".        *> file name of schema for document (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document validated by XML VALIDATE TEXT".
           Initialize Address-Struct.

           XML IMPORT TEXT
               Address-Struct     *> reference target data item (input)
               Document-Pointer   *> document pointer data item (input)
               Document-Length    *> length of document text to validate (input)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document memory imported by XML IMPORT TEXT".
           Perform Display-Address-Struct.

           XML PUT TEXT
               Document-Pointer   *> document pointer data item (input)
               Document-Length    *> length of document text (input)
               "address8".        *> target document file name (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document memory written by XML PUT TEXT".

           XML FREE TEXT
               Document-Pointer.  *> document pointer data item (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document memory released by XML FREE TEXT".
           Initialize Address-Struct.

           XML IMPORT FILE
               Address-Struct   *> reference to import target data item (input)
               "address8"       *> input document file name (input)
               Struct-Name.     *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address8.xml imported by XML IMPORT FILE".
           Perform Display-Address-Struct.

           Display Space.
           Display "You may inspect 'address8.xml'".
           Display Space.
           Go to Z.

       Display-Address-Struct.
           Display Space.
           Display "Name:        " Name.
           Display "Address-1:   " Address-1.
           Display "Address-2:   " Address-2.
           Display "Address-3:   " Address-3.
           Display "Country:     " Country.
           Display "Time-Stamp:  " Time-Stamp.

       Z.
           Copy "lixmltrm.cpy".

           Display "Press a key to terminate:".                         TESTS
           Accept Done.                                                 TESTS
           Stop Run.

           Copy "lixmldsp.cpy".

       End Program  Example-8.
