       Identification Division.
       Program-Id.  Example-9.
      *
      * Title: EXAMPLE9.CBL: Export / Transform / Import.
      *
      * Copyright (c) 2008-2014, Micro Focus (IP) Ltd.
      *
      * Version Identification:
      *   $Revision: 64691 $
      *   $Date: 2013-11-05 19:06:03 +0000 (Tue, 05 Nov 2013) $
      *
       Data Division.
       Working-Storage Section.

       Copy "s-struct.cpy".

       01  Done Pic X.
       01  WS-TimeStamp.
           02 WS-Date       PIC 9999/99/99.
           02 Filler        PIC XX Value Spaces.
           02 WS-Time       PIC 99/99/99/99.

       Copy "lixmlall.cpy".

       Procedure Division.
       A.
           Display "Example-9 - Illustrate TRANSFORM FILE".

           XML INITIALIZE.
           If Not XML-OK Go to Z End-If.

           Accept WS-Date From Date YYYYMMDD.
           Accept WS-Time From Time.
           Inspect WS-Time Converting "/" To ":".
           Move "." To WS-Time(9: 1).
           Move WS-TimeStamp To Time-Stamp.

           XML EXPORT FILE
               Address-Struct     *> reference to export source data item (input)
               "address9a"        *> output document file name (input)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address9a.xml exported by XML EXPORT FILE".
           Perform Display-Address-Struct.

           XML TRANSFORM FILE
               "address9a"        *> document to transform file name (input)
               "toext"            *> XSLT stylesheet file name (input)
               "address9b".       *> transformed document file name (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address9a.xml transformed into address9b.xml"
                   " by XML TRANSFORM FILE".
           Initialize Address-Struct.

           XML TRANSFORM FILE
               "address9b"        *> document to transform file name (input)
               "toint"            *> XSLT stylesheet file name (input)
               "address9c".       *> transformed document file name (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address9b.xml transformed into address9c.xml"
                   " by XML TRANSFORM FILE".
           Initialize Address-Struct.

           XML IMPORT FILE
               Address-Struct     *> document to transform file name (input)
               "address9c"        *> XSLT stylesheet file name (input)
               Struct-Name.       *> transformed document file name (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address9c.xml imported by XML IMPORT FILE".
           Perform Display-Address-Struct.

           XML TRANSFORM FILE
               "address9c"        *> document to transform file name (input)
               "example9"         *> XSLT stylesheet file name (input)
               "address9d".       *> transformed document file name (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address9c.xml transformed into address9d.xml"
                   " by XML TRANSFORM FILE".

           Display Space.
           Display "You may inspect "
                   "'address9a.xml' - 'address9d.xml'".
           Display Space.
           Go to Z.

       Display-Address-Struct.
           Display Space.
           Display "Name:        " Name.
           Display "Address-1:   " Address-1.
           Display "Address-2:   " Address-2.
           Display "Address-3:   " Address-3.
           Display "Country:     " Country.
           Display "Time-Stamp:  " Time-Stamp.

       Z.
           Copy "lixmltrm.cpy".

           Display "Press a key to terminate:".                         TESTS
           Accept Done.                                                 TESTS
           Stop Run.

           Copy "lixmldsp.cpy".

       End Program  Example-9.
