       Identification Division.
       Program-Id.  Example-B.
      *
      * Title: EXAMPLEB.CBL: Export / Import with Sparse Arrays.
      *
      * Copyright (c) 2008-2014, Micro Focus (IP) Ltd.
      *
      * Version Identification:
      *   $Revision: 64691 $
      *   $Date: 2013-11-05 19:06:03 +0000 (Tue, 05 Nov 2013) $
      *
       Data Division.
       Working-Storage Section.

       Copy "s-struct.cpy".

       01  Done            Pic X.
       01  WS-TimeStamp.
           02 WS-Date       PIC 9999/99/99.
           02 Filler        PIC XX Value Spaces.
           02 WS-Time       PIC 99/99/99/99.

       Copy "lixmlall.cpy".

       Procedure Division.
       A.
           Display "Example-B - Illustrate IMPORT with missing"
                   " intermediate names".

           XML INITIALIZE.
           If Not XML-OK Go to Z End-If.

           Accept WS-Date From Date YYYYMMDD.
           Accept WS-Time From Time.
           Inspect WS-Time Converting "/" To ":".
           Move "." To WS-Time(9: 1).
           Move WS-TimeStamp To Time-Stamp.

           XML EXPORT FILE
               Address-Struct     *> reference to export source data item (input)
               "addressb"         *> output document file name (input)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "addressb.xml exported by XML EXPORT FILE".
           Perform Display-Address-Struct.
           Initialize Address-Struct.

           XML IMPORT FILE
               Address-Struct     *> reference to import target data item (input)
               "addressb"         *> input document file name (input)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "addressb.xml imported by XML IMPORT FILE: ".
           Perform Display-Address-Struct.
           Initialize Address-Struct.

           XML IMPORT FILE
               Address-Struct     *> reference to import target data item (input)
               "x-addressb"       *> input document file name (input)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "x-addressb.xml imported by XML IMPORT FILE: ".
           Perform Display-Address-Struct.

           Display Space.
           Display "You may inspect "
                   "'addressb.xml' & 'x-addressb.xml'".
           Display Space.
           Go to Z.

       Display-Address-Struct.
           Display Space.
           Display "Name:        " Name.
           Display "Address-1:   " Address-1.
           Display "Address-2:   " Address-2.
           Display "Address-3:   " Address-3.
           Display "Country:     " Country.
           Display "Time-Stamp:  " Time-Stamp.

       Z.
           Copy "lixmltrm.cpy".

           Display "Press a key to terminate:".                         TESTS
           Accept Done.                                                 TESTS
           Stop Run.

           Copy "lixmldsp.cpy".

       End Program  Example-B.
