#!/bin/sh
# Ensure that the ACU extend 'bin' directory is in your PATH environment variable
# Ensure that the libxmlif shared object path is in your shared library path environment variable
#   (e.g., LD_LIBRARY_PATH, SHLIB_PATH, LIBPATH, etc. as appropriate for your platform)
for f in *.cbl; do ccbl -Ze $f; done
LIBXMLIF=libxmlif.so
if [ "`file \`which runcbl\` | sed -n -e 's/.*64-bit.*/64/p'`" = "64" ]; then LIBXMLIF=libxmlif64.so; fi
if [ "`file \`which runcbl\` | sed -n -e 's/.*ELF-64.*/64/p'`" = "64" ]; then LIBXMLIF=libxmlif64.so; fi
if [ "`file \`which runcbl\` | sed -n -e 's/.*PA-RISC.*/sl/p'`" = "sl" ]; then LIBXMLIF=libxmlif.sl; fi
if [ "`file \`which runcbl\` | sed -n -e 's/.*PA-RISC 2.*/sl/p'`" = "sl" ]; then LIBXMLIF=libxmlif64.sl; fi
if [ ! -d ./stamp ]; then mkdir ./stamp; fi
for f in *.acu; do runcbl -y $LIBXMLIF $f; done
