<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>

  <xsl:template match="/">
    <xsl:apply-templates select="address-struct"/>
  </xsl:template>

  <xsl:template match="address-struct">
    <xsl:comment>Elements converted to attributes.</xsl:comment>
    <AddressStruct>
     <Information>
      <xsl:attribute name="Name">
       <xsl:value-of select="name/text()"/>
      </xsl:attribute>
      <xsl:attribute name="Address1">
       <xsl:value-of select="address-1/text()"/>
      </xsl:attribute>
      <xsl:attribute name="Address2">
       <xsl:value-of select="address-2/text()"/>
      </xsl:attribute>
      <xsl:attribute name="City">
       <xsl:value-of select="address-3/city/text()"/>
      </xsl:attribute>
      <xsl:attribute name="State">
       <xsl:value-of select="address-3/state/text()"/>
      </xsl:attribute>
      <xsl:attribute name="Zip">
       <xsl:value-of select="address-3/zip/text()"/>
      </xsl:attribute>
      <xsl:attribute name="Country">
       <xsl:value-of select="country/text()"/>
      </xsl:attribute>
     </Information>
     <TimeStamp>
      <xsl:attribute name="Value">
       <xsl:value-of select="time-stamp/text()"/>
      </xsl:attribute>
     </TimeStamp>
    </AddressStruct>
  </xsl:template>
</xsl:stylesheet>
